/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.db;

import com.networknt.config.Config;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDataSource {
    public static final String DATASOURCE = "datasource";
    public static final String DB_PASSWORD = "password";
    public static final String DS_NAME = "H2DataSource";
    public static final String PARAMETERS = "parameters";
    public static final String SETTINGS = "settings";
    public static final String JDBC_URL = "jdbcUrl";
    public static final String USERNAME = "username";
    public static final String MAXIMUM_POOL_SIZE = "maximumPoolSize";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    private static final Logger logger = LoggerFactory.getLogger(GenericDataSource.class);
    private HikariDataSource ds;
    protected String dsName;
    protected Map<String, Object> dataSourceMap;

    public String getDsName() {
        return this.dsName;
    }

    public String getDbPassKey() {
        return DB_PASSWORD;
    }

    public GenericDataSource() {
        this.dsName = DS_NAME;
        this.ds = this.createDataSource();
    }

    public GenericDataSource(String dsName) {
        this.dsName = dsName;
        this.ds = this.createDataSource();
    }

    protected HikariDataSource createDataSource() {
        this.dataSourceMap = Config.getInstance().getJsonMapConfig(DATASOURCE);
        Map mainParams = (Map)this.dataSourceMap.get(this.getDsName());
        Map configParams = (Map)mainParams.get(PARAMETERS);
        Map settings = (Map)mainParams.get(SETTINGS);
        this.ds = new HikariDataSource();
        this.ds.setJdbcUrl((String)mainParams.get(JDBC_URL));
        this.ds.setUsername((String)mainParams.get(USERNAME));
        String password = (String)mainParams.get(DB_PASSWORD);
        this.ds.setPassword(password);
        this.ds.setMaximumPoolSize(Config.loadIntegerValue((String)MAXIMUM_POOL_SIZE, mainParams.get(MAXIMUM_POOL_SIZE)).intValue());
        this.ds.setConnectionTimeout((long)Config.loadIntegerValue((String)CONNECTION_TIMEOUT, mainParams.get(CONNECTION_TIMEOUT)).intValue());
        if (settings != null && settings.size() > 0) {
            for (Map.Entry entry : settings.entrySet()) {
                String fieldName = (String)entry.getKey();
                try {
                    Method method = this.findMethod(this.ds.getClass(), "set" + this.convertFirstLetterUpper(fieldName), entry.getValue().getClass());
                    method.invoke((Object)this.ds, entry.getValue());
                }
                catch (Exception e) {
                    logger.error("no such set method on datasource for setting value:" + fieldName);
                }
            }
        }
        if (configParams != null) {
            configParams.forEach((k, v) -> this.ds.addDataSourceProperty(k, v));
        }
        return this.ds;
    }

    private String convertFirstLetterUpper(String field) {
        return field.substring(0, 1).toUpperCase() + field.substring(1);
    }

    public HikariDataSource getDataSource() {
        return this.ds;
    }

    public Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (Method method : clazz.getMethods()) {
                Class<?>[] acceptedParameterTypes;
                String name = method.getName();
                if (!methodName.equals(name) || (acceptedParameterTypes = method.getParameterTypes()).length != parameterTypes.length) continue;
                return method;
            }
            throw new NoSuchMethodException();
        }
    }
}

