/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.db.factory;

import com.networknt.config.Config;
import com.networknt.db.GenericDataSource;
import com.networknt.db.factory.DataSourceFactory;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class DefaultDataSourceFactory
implements DataSourceFactory {
    public static final String DATASOURCE = "datasource";
    public static final Map<String, DataSource> dataSources = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Object> dataSourceMap = Config.getInstance().getJsonMapConfig("datasource");

    @Override
    public DataSource getDataSource(String name) {
        HikariDataSource hkDs;
        if (dataSources.containsKey(name)) {
            return dataSources.get(name);
        }
        GenericDataSource genericDataSource = new GenericDataSource(name);
        HikariDataSource result = hkDs = genericDataSource.getDataSource();
        dataSources.put(name, (DataSource)result);
        return result;
    }
}

