/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator.impl;

import com.networknt.jsonoverlay.IJsonOverlay;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.EncodingProperty;
import com.networknt.oas.model.Example;
import com.networknt.oas.model.MediaType;
import com.networknt.oas.model.Schema;
import com.networknt.oas.validator.ObjectValidatorBase;
import com.networknt.oas.validator.ValidationResults;
import com.networknt.oas.validator.impl.EncodingPropertyValidator;
import com.networknt.oas.validator.impl.ExampleValidator;
import com.networknt.oas.validator.impl.OpenApi3Messages;
import com.networknt.oas.validator.impl.SchemaValidator;
import com.networknt.oas.validator.msg.Messages;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class MediaTypeValidator
extends ObjectValidatorBase<MediaType> {
    @Override
    public void runObjectValidations() {
        MediaType mediaType = (MediaType)this.value.getOverlay();
        this.validateField("schema", false, Schema.class, new SchemaValidator(), new Consumer[0]);
        this.validateMapField("encodingProperties", false, false, EncodingProperty.class, new EncodingPropertyValidator());
        this.checkEncodingPropsAreProps(mediaType, this.results);
        this.validateExtensions(mediaType.getExtensions());
        Overlay<Map<String, Example>> examples = this.validateMapField("examples", false, false, Example.class, new ExampleValidator());
        Overlay<Object> example = this.validateField("example", false, Object.class, null, new Consumer[0]);
        this.checkExampleExclusion(examples, example);
    }

    void checkEncodingPropsAreProps(MediaType mediaType, ValidationResults results) {
        Schema schema = mediaType.getSchema(false);
        if (Overlay.of((IJsonOverlay)schema).isElaborated()) {
            Set<String> propNames = schema.getProperties().keySet();
            Map<String, EncodingProperty> encProps = mediaType.getEncodingProperties();
            for (String encodingPropertyName : encProps.keySet()) {
                if (propNames.contains(encodingPropertyName)) continue;
                results.addError(Messages.msg(OpenApi3Messages.EncPropNotSchemaProp, encodingPropertyName), Overlay.of(encProps, (String)encodingPropertyName));
            }
        }
    }

    void checkExampleExclusion(Overlay<Map<String, Example>> examples, Overlay<Object> example) {
        boolean examplePresent;
        boolean examplesPresent = examples != null && examples.isPresent() && Overlay.getMapOverlay(examples).size() > 0;
        boolean bl = examplePresent = example != null && example.isPresent();
        if (examplesPresent && examplePresent) {
            this.results.addError("ExmplExclusion|The 'example' and 'exmaples' properties may not both appear", this.value);
        }
    }
}

