/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.assets;

import com.neuronrobotics.bowlerstudio.assets.StudioBuildInfo;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.fxml.FXMLLoader;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;

public class AssetFactory {
    public static final String repo = "BowlerStudioImageAssets";
    private static String gitSource = "https://github.com/madhephaestus/BowlerStudioImageAssets.git";
    private static HashMap<String, Image> cache = new HashMap();
    private static HashMap<String, FXMLLoader> loaders = new HashMap();
    private static String assetRepoBranch = "";

    private AssetFactory() {
    }

    public static FXMLLoader loadLayout(String file, boolean refresh) throws Exception {
        File fxmlFIle = AssetFactory.loadFile(file);
        URL fileURL = fxmlFIle.toURI().toURL();
        if (loaders.get(file) == null || refresh) {
            loaders.put(file, new FXMLLoader(fileURL));
        }
        loaders.get(file).setLocation(fileURL);
        return loaders.get(file);
    }

    public static FXMLLoader loadLayout(String file) throws Exception {
        return AssetFactory.loadLayout(file, false);
    }

    public static File loadFile(String file) throws Exception {
        return ScriptingEngine.fileFromGit(AssetFactory.getGitSource(), AssetFactory.getAssetRepoBranch(), file);
    }

    public static void writeImage(Image img, File file) {
        int width = (int)img.getWidth();
        int height = (int)img.getHeight();
        PixelReader reader = img.getPixelReader();
        byte[] buffer = new byte[width * height * 4];
        WritablePixelFormat format = PixelFormat.getByteBgraInstance();
        reader.getPixels(0, 0, width, height, format, buffer, 0, width * 4);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            for (int count = 0; count < buffer.length; count += 4) {
                out.write(buffer[count + 2]);
                out.write(buffer[count + 1]);
                out.write(buffer[count]);
                out.write(buffer[count + 3]);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Image loadAsset(String file) throws Exception {
        if (cache.get(file) == null) {
            File f = AssetFactory.loadFile(file);
            if (f.getName().endsWith(".fxml")) {
                AssetFactory.loadLayout(file);
                return null;
            }
            if ((f == null || !f.exists()) && f.getName().endsWith(".png")) {
                WritableImage obj_img = new WritableImage(30, 30);
                int alpha = 0;
                int cx = 0;
                while ((double)cx < obj_img.getWidth()) {
                    int cy = 0;
                    while ((double)cy < obj_img.getHeight()) {
                        int color = obj_img.getPixelReader().getArgb(cx, cy);
                        int mc = alpha << 24 | 0xFFFFFF;
                        int newColor = color & mc;
                        obj_img.getPixelWriter().setArgb(cx, cy, newColor);
                        ++cy;
                    }
                    ++cx;
                }
                cache.put(file, (Image)obj_img);
                System.out.println("No image at " + file);
                try {
                    File imageFile = ScriptingEngine.createFile(AssetFactory.getGitSource(), file, "create file");
                    try {
                        String fileName = imageFile.getName();
                        AssetFactory.writeImage((Image)obj_img, imageFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ScriptingEngine.createFile(AssetFactory.getGitSource(), file, "saving new content");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (f.getName().endsWith(".png")) {
                cache.put(file, new Image(f.toURI().toString()));
            } else {
                return null;
            }
        }
        return cache.get(file);
    }

    public static ImageView loadIcon(String file) {
        try {
            return new ImageView(AssetFactory.loadAsset(file));
        }
        catch (Exception e) {
            return new ImageView();
        }
    }

    public static String getGitSource() throws Exception {
        return gitSource;
    }

    public static void setGitSource(String gitSource, String assetRepoBranch) throws Exception {
        System.err.println("Assets from: " + gitSource + "#" + assetRepoBranch);
        AssetFactory.setAssetRepoBranch(assetRepoBranch);
        AssetFactory.gitSource = gitSource;
        cache.clear();
        AssetFactory.loadAllAssets();
    }

    public static void loadAllAssets() throws Exception {
        System.err.println("Loading assets");
        ArrayList<String> files = ScriptingEngine.filesInGit(gitSource, StudioBuildInfo.getVersion(), null);
        for (String file : files) {
            System.err.println("Loading asset file: " + file);
            AssetFactory.loadAsset(file);
        }
    }

    public static String getAssetRepoBranch() {
        return assetRepoBranch;
    }

    public static void setAssetRepoBranch(String assetRepoBranch) {
        AssetFactory.assetRepoBranch = assetRepoBranch;
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    AssetFactory.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }
}

