/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.physics;

import com.bulletphysics.dynamics.constraintsolver.HingeConstraint;
import com.bulletphysics.linearmath.Transform;
import com.neuronrobotics.bowlerstudio.physics.CSGPhysicsManager;
import com.neuronrobotics.bowlerstudio.physics.PhysicsCore;
import com.neuronrobotics.sdk.common.IClosedLoopController;
import eu.mihosoft.vrl.v3d.CSG;
import java.util.ArrayList;
import javafx.scene.paint.Color;

public class HingeCSGPhysicsManager
extends CSGPhysicsManager {
    private HingeConstraint constraint = null;
    private IClosedLoopController controller = null;
    private double target = 0.0;
    private static float muscleStrength = 1000.0f;
    boolean flagBroken = false;
    private double velocity;

    public HingeCSGPhysicsManager(ArrayList<CSG> baseCSG, Transform pose, double mass, PhysicsCore c) {
        super(baseCSG, pose, mass, false, c);
    }

    @Override
    public void update(float timeStep) {
        super.update(timeStep);
        if (this.constraint != null && this.getController() != null && !this.flagBroken) {
            this.velocity = this.getController().compute((double)this.constraint.getHingeAngle(), this.getTarget(), (double)timeStep);
            this.constraint.enableAngularMotor(true, (float)this.velocity, HingeCSGPhysicsManager.getMuscleStrength());
            if (this.constraint.getAppliedImpulse() > HingeCSGPhysicsManager.getMuscleStrength()) {
                for (CSG c1 : this.baseCSG) {
                    c1.setColor(Color.WHITE);
                }
                this.flagBroken = true;
                this.getCore().remove(this);
                this.setConstraint(null);
                this.getCore().add(this);
                System.out.println("ERROR Link Broken, Strength: " + HingeCSGPhysicsManager.getMuscleStrength() + " applied impluse " + this.constraint.getAppliedImpulse());
            }
        } else if (this.constraint != null && this.flagBroken) {
            this.constraint.enableAngularMotor(false, 0.0f, 0.0f);
        }
    }

    public HingeConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(HingeConstraint constraint) {
        this.constraint = constraint;
    }

    public double getTarget() {
        return this.target;
    }

    public void setTarget(double target) {
        this.target = target;
    }

    public static float getMuscleStrength() {
        return muscleStrength;
    }

    public static void setMuscleStrength(float ms) {
        muscleStrength = ms;
    }

    public void setMuscleStrength(double muscleStrength) {
        HingeCSGPhysicsManager.setMuscleStrength((float)muscleStrength);
    }

    public IClosedLoopController getController() {
        return this.controller;
    }

    public void setController(IClosedLoopController controller) {
        this.controller = controller;
    }
}

