/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.scripting;

import com.neuronrobotics.bowlerstudio.scripting.IScriptingLanguage;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ArduinoLoader
implements IScriptingLanguage {
    private static String ARDUINO = "arduino";
    HashMap<String, HashMap<String, Object>> database;
    private static String defaultPort = null;
    private static String defaultBoard = null;
    private static boolean loadedBowler = false;

    @Override
    public Object inlineScriptRun(File code, ArrayList<Object> args) throws Exception {
        if (args == null) {
            args = new ArrayList();
        }
        if (this.database == null) {
            this.database = (HashMap)ScriptingEngine.gitScriptRun("https://github.com/madhephaestus/Arduino-Boards-JSON.git", "boards.json", null);
        }
        String execString = ArduinoLoader.getARDUINOExec();
        if (args.size() > 0) {
            ArduinoLoader.setDefaultBoard((String)args.get(0));
        }
        if (ArduinoLoader.getDefaultBoard() != null) {
            execString = execString + " --board " + ArduinoLoader.getDefaultBoard();
            if (args.size() > 1) {
                ArduinoLoader.setDefaultPort((String)args.get(1));
            }
        }
        if (ArduinoLoader.getDefaultPort() != null) {
            execString = execString + " --port " + ArduinoLoader.getDefaultPort();
        }
        HashMap<String, Object> configs = this.database.get(ArduinoLoader.getDefaultBoard());
        File ino = this.findIno(code);
        if (ino == null) {
            return null;
        }
        execString = execString + " --upload " + ino.getAbsolutePath().replaceAll(" ", "\\ ");
        if (!loadedBowler) {
            loadedBowler = true;
            ArduinoLoader.run(ArduinoLoader.getARDUINOExec() + " --install-library BowlerCom");
        }
        ArduinoLoader.run(execString);
        return null;
    }

    public static void installBoard(String product, String arch) throws Exception {
        ArduinoLoader.run(ArduinoLoader.getARDUINOExec() + " --install-boards " + product + ":" + arch);
    }

    public static void installLibrary(String lib) throws Exception {
        ArduinoLoader.run(ArduinoLoader.getARDUINOExec() + " --install-library " + lib);
    }

    public static void run(String execString) throws Exception {
        System.out.println("Running:\n" + execString);
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(execString);
        p.waitFor();
        InputStream is = p.getInputStream();
        InputStream err = p.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        BufferedReader readerErr = new BufferedReader(new InputStreamReader(err));
        String s = null;
        while ((s = reader.readLine()) != null) {
            System.out.println(s);
        }
        s = null;
        while ((s = readerErr.readLine()) != null) {
            System.out.println(s);
        }
        is.close();
        err.close();
    }

    private File findIno(File start) {
        if (start == null) {
            return null;
        }
        if (start.getName().endsWith(".ino")) {
            return start;
        }
        File dir = start.getParentFile();
        if (dir != null) {
            for (File f : dir.listFiles()) {
                if (this.findIno(f) == null) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    public Object inlineScriptRun(String code, ArrayList<Object> args) throws Exception {
        return null;
    }

    @Override
    public String getShellType() {
        return "Arduino";
    }

    @Override
    public boolean getIsTextFile() {
        return true;
    }

    public static String getDefaultPort() {
        return defaultPort;
    }

    public static void setDefaultPort(String defaultPort) {
        ArduinoLoader.defaultPort = defaultPort;
    }

    public static String getDefaultBoard() {
        return defaultBoard;
    }

    public static void setDefaultBoard(String defaultBoard) {
        ArduinoLoader.defaultBoard = defaultBoard;
    }

    public static String getARDUINOExec() {
        return ARDUINO;
    }

    public static void setARDUINOExec(String aRDUINO) {
        ARDUINO = aRDUINO;
    }

    @Override
    public ArrayList<String> getFileExtenetion() {
        return new ArrayList<String>(Arrays.asList("c", "ino", "h", "cpp", "hpp"));
    }
}

