/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.scripting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.neuronrobotics.bowlerstudio.scripting.IScriptingLanguage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class JsonRunner
implements IScriptingLanguage {
    private static Type TT_mapStringString = new TypeToken<HashMap<String, HashMap<String, Object>>>(){}.getType();
    private static Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    @Override
    public Object inlineScriptRun(File code, ArrayList<Object> args) throws Exception {
        String jsonString = null;
        FileInputStream inPut = null;
        inPut = FileUtils.openInputStream((File)code);
        jsonString = IOUtils.toString((InputStream)inPut);
        return this.inlineScriptRun(jsonString, args);
    }

    @Override
    public Object inlineScriptRun(String code, ArrayList<Object> args) throws Exception {
        HashMap database = (HashMap)gson.fromJson(code, TT_mapStringString);
        return database;
    }

    @Override
    public String getShellType() {
        return "JSON";
    }

    @Override
    public boolean getIsTextFile() {
        return true;
    }

    @Override
    public ArrayList<String> getFileExtenetion() {
        return new ArrayList<String>(Arrays.asList("json"));
    }
}

