/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.scripting;

import com.neuronrobotics.bowlerstudio.scripting.IScriptingLanguage;
import com.neuronrobotics.sdk.common.BowlerAbstractDevice;
import com.neuronrobotics.sdk.common.DeviceManager;
import com.neuronrobotics.sdk.common.Log;
import eu.mihosoft.vrl.v3d.CSG;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javafx.scene.control.Tab;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class JythonHelper
implements IScriptingLanguage {
    PythonInterpreter interp;

    @Override
    public Object inlineScriptRun(String code, ArrayList<Object> args) {
        Properties props = new Properties();
        PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)props, (String[])new String[]{""});
        if (this.interp == null) {
            this.interp = new PythonInterpreter();
            this.interp.exec("import sys");
        }
        for (String pm : DeviceManager.listConnectedDevice(null)) {
            BowlerAbstractDevice bad = DeviceManager.getSpecificDevice(null, (String)pm);
            try {
                this.interp.set(bad.getScriptingName(), Class.forName(bad.getClass().getName()).cast(bad));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            System.err.println("Device " + bad.getScriptingName() + " is " + bad);
        }
        this.interp.set("args", args);
        this.interp.exec(code);
        ArrayList<Object> results = new ArrayList<Object>();
        PyObject localVariables = this.interp.getLocals();
        try {
            results.add(this.interp.get("csg", CSG.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            results.add(this.interp.get("tab", Tab.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            results.add(this.interp.get("device", BowlerAbstractDevice.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.debug((String)("Jython return = " + results));
        return results;
    }

    @Override
    public Object inlineScriptRun(File code, ArrayList<Object> args) {
        try {
            byte[] bytes = Files.readAllBytes(code.toPath());
            String s = new String(bytes, "UTF-8");
            return this.inlineScriptRun(s, args);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    @Override
    public String getShellType() {
        return "Jython";
    }

    @Override
    public boolean getIsTextFile() {
        return true;
    }

    @Override
    public ArrayList<String> getFileExtenetion() {
        return new ArrayList<String>(Arrays.asList("py", "jy"));
    }
}

