/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.scripting;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.JsonKeysetReader;
import com.google.crypto.tink.JsonKeysetWriter;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.aead.AeadKeyTemplates;
import com.google.crypto.tink.config.TinkConfig;
import com.google.crypto.tink.proto.KeyTemplate;
import com.neuronrobotics.bowlerstudio.scripting.IGitHubLoginManager;
import com.neuronrobotics.bowlerstudio.scripting.ScriptingEngine;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.kohsuke.github.GitHub;

public class PasswordManager {
    private static IGitHubLoginManager loginManager = new IGitHubLoginManager(){

        @Override
        public String[] prompt(String username) {
            if (username != null && username.equals("")) {
                username = null;
            }
            String[] creds = new String[]{"", ""};
            System.out.println("#Github Login Prompt#");
            System.out.println("For anynomous mode hit enter twice");
            System.out.print("Github Username: " + (username != null ? "(" + username + ")" : ""));
            BufferedReader buf = new BufferedReader(new InputStreamReader(System.in));
            do {
                try {
                    creds[0] = buf.readLine();
                    System.out.println("GitHub Username: " + creds[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
                if (creds[0].equals("") && username == null) {
                    System.out.println("No username, using anynomous login");
                    return null;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (creds[0] == null);
            try {
                char[] passwd;
                Console cons = System.console();
                if (cons != null && (passwd = cons.readPassword("[%s]", "GitHub Password:")) != null) {
                    creds[1] = new String(passwd);
                    Arrays.fill(passwd, ' ');
                }
                if (creds[1].equals("")) {
                    System.out.println("No password, using anynomous login");
                }
            }
            catch (Exception e) {
                return null;
            }
            return creds;
        }
    };
    private static File usernamefile;
    private static File passfile;
    private static File keyfile;
    private static File workspace;
    private static String loginID;
    private static String pw;
    private static CredentialsProvider cp;
    private static GitHub github;
    private static boolean hasnetwork;
    private static boolean isLoggedIn;

    public static void checkInternet() {
        try {
            URL url = new URL("http://github.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream();
            hasnetwork = true;
        }
        catch (Exception e) {
            hasnetwork = false;
        }
    }

    static String getPassword() {
        return pw;
    }

    public static GitHub getGithub() {
        return github;
    }

    public static void setGithub(GitHub g) {
        github = g;
    }

    public static String getUsername() {
        return PasswordManager.getLoginID();
    }

    static synchronized void login() throws IOException {
        boolean c2;
        PasswordManager.checkInternet();
        if (!hasnetwork) {
            return;
        }
        boolean b = !PasswordManager.hasStoredCredentials();
        boolean c = !isLoggedIn;
        boolean bl = c2 = c && b;
        if (c2) {
            String[] creds = loginManager.prompt(PasswordManager.getUsername());
            PasswordManager.setLoginID(creds[0]);
            pw = creds[1];
            try {
                PasswordManager.waitForLogin();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void waitForLogin() throws Exception {
        if (!hasnetwork) {
            return;
        }
        if (PasswordManager.loggedIn()) {
            return;
        }
        if (PasswordManager.getLoginID() != null && pw != null) {
            PasswordManager.performLogin(PasswordManager.getLoginID(), pw);
            if (PasswordManager.getGithub() == null) {
                System.out.println("\nERROR: Wrong Password!\n");
                PasswordManager.login();
            }
        }
    }

    private static void performLogin(String u, String p) {
        try {
            github = null;
            GitHub gh = GitHub.connectUsingPassword((String)u, (String)p);
            if (gh.getRateLimit().remaining < 2) {
                System.err.println("##Github Is Rate Limiting You## Disabling autoupdate");
            }
            PasswordManager.setGithub(gh);
            PasswordManager.setCredentialProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(u, p));
            isLoggedIn = true;
            PasswordManager.writeData(u, p);
            System.out.println("\n\nSuccess Login " + u + "\n\n");
        }
        catch (Exception e) {
            github = null;
        }
    }

    public static boolean loggedIn() {
        return isLoggedIn;
    }

    public static boolean hasStoredCredentials() {
        if (usernamefile != null && passfile != null) {
            return usernamefile.exists() && passfile.exists();
        }
        return false;
    }

    public static void logout() throws IOException {
        PasswordManager.setGithub(null);
        isLoggedIn = false;
        if (passfile != null && passfile.exists()) {
            passfile.delete();
        }
        pw = null;
        cp = null;
    }

    public static GitHub setupAnyonmous() throws IOException {
        System.err.println("Using anynomous login, autoupdate disabled");
        ScriptingEngine.setAutoupdate(false);
        PasswordManager.logout();
        PasswordManager.setGithub(GitHub.connectAnonymously());
        return PasswordManager.getGithub();
    }

    public static IGitHubLoginManager getLoginManager() {
        return loginManager;
    }

    public static void setLoginManager(IGitHubLoginManager lm) {
        loginManager = lm;
    }

    static void loadLoginData(File ws) throws Exception {
        workspace = ws;
        usernamefile = new File(workspace.getAbsoluteFile() + "/username.json");
        if (!usernamefile.exists()) {
            usernamefile = null;
        } else {
            List<String> linesu = Files.readAllLines(Paths.get(usernamefile.toURI()), StandardCharsets.UTF_8);
            PasswordManager.setLoginID(linesu.get(0));
        }
        KeysetHandle keysetHandle = PasswordManager.getKey();
        passfile = new File(workspace.getAbsoluteFile() + "/timestamp.json");
        if (!passfile.exists()) {
            passfile = null;
        }
        if (PasswordManager.hasStoredCredentials()) {
            byte[] passEncrypt = Files.readAllBytes(Paths.get(passfile.toURI()));
            Aead aead = (Aead)keysetHandle.getPrimitive(Aead.class);
            try {
                byte[] decrypted = aead.decrypt(passEncrypt, null);
                String cleartext = new String(decrypted).trim();
                PasswordManager.performLogin(PasswordManager.getLoginID(), cleartext);
            }
            catch (GeneralSecurityException ex) {
                ex.printStackTrace();
                PasswordManager.logout();
            }
        }
    }

    private static KeysetHandle getKey() throws IOException {
        KeysetHandle keysetHandle = null;
        keyfile = new File(workspace.getAbsoluteFile() + "/loadData.json");
        String keysetFilename = keyfile.getAbsolutePath();
        if (!keyfile.exists()) {
            System.err.println("Creating keyfile ");
            try {
                keysetHandle = KeysetHandle.generateNew((KeyTemplate)AeadKeyTemplates.AES128_GCM);
                CleartextKeysetHandle.write((KeysetHandle)keysetHandle, (KeysetWriter)JsonKeysetWriter.withFile((File)new File(keysetFilename)));
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Loading keyfile ");
            try {
                keysetHandle = CleartextKeysetHandle.read((KeysetReader)JsonKeysetReader.withFile((File)new File(keysetFilename)));
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
        }
        return keysetHandle;
    }

    private static void writeData(String user, String passcleartext) throws Exception {
        PasswordManager.setLoginID(user);
        pw = passcleartext;
        usernamefile = new File(workspace.getAbsoluteFile() + "/username.json");
        if (!usernamefile.exists()) {
            usernamefile.createNewFile();
        }
        Files.write(Paths.get(usernamefile.toURI()), user.getBytes(), new OpenOption[0]);
        KeysetHandle keysetHandle = PasswordManager.getKey();
        passfile = new File(workspace.getAbsoluteFile() + "/timestamp.json");
        if (!passfile.exists()) {
            passfile.createNewFile();
        }
        Aead aead = (Aead)keysetHandle.getPrimitive(Aead.class);
        byte[] ciphertext = aead.encrypt(passcleartext.getBytes(), null);
        Files.write(Paths.get(passfile.toURI()), ciphertext, new OpenOption[0]);
    }

    public static CredentialsProvider getCredentialProvider() {
        return cp;
    }

    private static void setCredentialProvider(CredentialsProvider cp) {
        PasswordManager.cp = cp;
    }

    public static boolean hasNetwork() {
        return hasnetwork;
    }

    public static String getLoginID() {
        return loginID;
    }

    private static void setLoginID(String loginID) {
        PasswordManager.loginID = loginID;
    }

    static {
        PasswordManager.checkInternet();
        try {
            TinkConfig.register();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        usernamefile = null;
        passfile = null;
        keyfile = null;
        workspace = null;
        loginID = null;
        pw = null;
        isLoggedIn = false;
    }
}

