/*
 * Decompiled with CFR 0.152.
 */
package com.neuronrobotics.bowlerstudio.scripting;

import com.neuronrobotics.bowlerstudio.scripting.ArduinoLoader;
import com.neuronrobotics.bowlerstudio.scripting.ClojureHelper;
import com.neuronrobotics.bowlerstudio.scripting.GroovyHelper;
import com.neuronrobotics.bowlerstudio.scripting.IGitHubLoginManager;
import com.neuronrobotics.bowlerstudio.scripting.IGithubLoginListener;
import com.neuronrobotics.bowlerstudio.scripting.IScriptingLanguage;
import com.neuronrobotics.bowlerstudio.scripting.JsonRunner;
import com.neuronrobotics.bowlerstudio.scripting.JythonHelper;
import com.neuronrobotics.bowlerstudio.scripting.PasswordManager;
import com.neuronrobotics.bowlerstudio.scripting.RobotHelper;
import com.neuronrobotics.bowlerstudio.util.FileChangeWatcher;
import com.neuronrobotics.sdk.common.Log;
import com.neuronrobotics.sdk.util.ThreadUtil;
import eu.mihosoft.vrl.v3d.parametrics.CSGDatabase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javafx.scene.web.WebEngine;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotAdvertisedException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GitHub;

public class ScriptingEngine {
    private static final int TIME_TO_WAIT_BETWEEN_GIT_PULL = 100000;
    private static final Map<String, Long> fileLastLoaded;
    private static boolean autoupdate;
    private static final String[] imports;
    private static HashMap<String, File> filesRun;
    private static File workspace;
    private static File lastFile;
    private static ArrayList<IGithubLoginListener> loginListeners;
    private static HashMap<String, IScriptingLanguage> langauges;

    public static Object inlineScriptRun(File code, ArrayList<Object> args, String shellTypeStorage) throws Exception {
        if (filesRun.get(code.getName()) == null) {
            filesRun.put(code.getName(), code);
        }
        if (langauges.get(shellTypeStorage) != null) {
            return langauges.get(shellTypeStorage).inlineScriptRun(code, args);
        }
        return null;
    }

    public static Object inlineScriptStringRun(String line, ArrayList<Object> args, String shellTypeStorage) throws Exception {
        if (langauges.get(shellTypeStorage) != null) {
            return langauges.get(shellTypeStorage).inlineScriptRun(line, args);
        }
        return null;
    }

    public static void addScriptingLanguage(IScriptingLanguage lang) {
        langauges.put(lang.getShellType(), lang);
    }

    public static void addIGithubLoginListener(IGithubLoginListener l) {
        if (!loginListeners.contains(l)) {
            loginListeners.add(l);
        }
    }

    public static void removeIGithubLoginListener(IGithubLoginListener l) {
        if (loginListeners.contains(l)) {
            loginListeners.remove(l);
        }
    }

    public static File getWorkspace() {
        return workspace;
    }

    public static String getShellType(String name) {
        for (IScriptingLanguage l : langauges.values()) {
            if (!l.isSupportedFileExtenetion(name)) continue;
            return l.getShellType();
        }
        return "Groovy";
    }

    public static void login() throws IOException {
        if (!PasswordManager.hasNetwork()) {
            return;
        }
        PasswordManager.login();
        if (PasswordManager.loggedIn()) {
            for (IGithubLoginListener l : loginListeners) {
                l.onLogin(PasswordManager.getUsername());
            }
        }
    }

    public static void logout() throws IOException {
        for (IGithubLoginListener l : loginListeners) {
            l.onLogout(PasswordManager.getUsername());
        }
        PasswordManager.logout();
    }

    public static GitHub setupAnyonmous() throws IOException {
        return PasswordManager.setupAnyonmous();
    }

    public static String urlToGist(String in) {
        String domain;
        String[] tokens;
        if (in.endsWith(".git")) {
            in = in.substring(0, in.lastIndexOf(46));
        }
        if ((tokens = (domain = in.split("//")[1]).split("/"))[0].toLowerCase().contains("gist.github.com") && tokens.length >= 2) {
            try {
                String id = tokens[2].split("#")[0];
                Log.debug((String)("Gist URL Detected " + id));
                return id;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                try {
                    String id = tokens[1].split("#")[0];
                    Log.debug((String)("Gist URL Detected " + id));
                    return id;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    Log.error((String)("Parsing " + in + " failed to find gist"));
                    return "d4312a0787456ec27a2a";
                }
            }
        }
        return null;
    }

    private static List<String> returnFirstGist(String html) {
        ArrayList<String> ret = new ArrayList<String>();
        Document doc = Jsoup.parse((String)html);
        Elements links = doc.select("script");
        for (int i = 0; i < links.size(); ++i) {
            Element e = (Element)links.get(i);
            Attributes n = e.attributes();
            String jSSource = n.get("src");
            if (!jSSource.contains("https://gist.github.com/")) continue;
            String slug = jSSource;
            String js = slug.split(".js")[0];
            String[] id = js.split("/");
            ret.add(id[id.length - 1]);
        }
        return ret;
    }

    public static List<String> getCurrentGist(String addr, WebEngine engine) {
        String gist = ScriptingEngine.urlToGist(addr);
        if (gist == null) {
            try {
                Log.debug((String)"Non Gist URL Detected");
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer t = tf.newTransformer();
                StringWriter sw = new StringWriter();
                t.transform(new DOMSource(engine.getDocument()), new StreamResult(sw));
                String html = sw.getBuffer().toString();
                return ScriptingEngine.returnFirstGist(html);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(gist);
        return ret;
    }

    public static void waitForLogin() throws IOException, InvalidRemoteException, TransportException, GitAPIException {
        if (!PasswordManager.hasNetwork()) {
            return;
        }
        try {
            PasswordManager.waitForLogin();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteRepo(String remoteURI) {
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        ScriptingEngine.deleteFolder(gitRepoFile.getParentFile());
    }

    public static void deleteCache() {
        ScriptingEngine.deleteFolder(new File(ScriptingEngine.getWorkspace().getAbsolutePath() + "/gitcache/"));
    }

    public static void deleteFolder(File folder) {
        if (!folder.exists() || !folder.isDirectory()) {
            throw new RuntimeException("Folder doesnt exist " + folder);
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    ScriptingEngine.deleteFolder(f);
                    continue;
                }
                try {
                    FileChangeWatcher.close(f);
                    f.delete();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        try {
            folder.delete();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void loadFilesToList(ArrayList<String> f, File directory, String extnetion) {
        if (directory == null) {
            return;
        }
        block0: for (File fileEntry : directory.listFiles()) {
            if (fileEntry.getName().endsWith(".git") || fileEntry.getName().startsWith(".git") || extnetion != null && extnetion.length() > 0 && !fileEntry.getName().endsWith(extnetion)) continue;
            if (fileEntry.isDirectory()) {
                ScriptingEngine.loadFilesToList(f, fileEntry, extnetion);
                continue;
            }
            for (IScriptingLanguage l : langauges.values()) {
                if (!l.isSupportedFileExtenetion(fileEntry.getName())) continue;
                f.add(ScriptingEngine.findLocalPath(fileEntry));
                continue block0;
            }
        }
    }

    public static ArrayList<String> filesInGit(String remote, String branch, String extnetion) throws Exception {
        ArrayList<String> f = new ArrayList<String>();
        File gistDir = ScriptingEngine.cloneRepo(remote, branch);
        ScriptingEngine.loadFilesToList(f, gistDir, extnetion);
        return f;
    }

    public static ArrayList<String> filesInGit(String remote) throws Exception {
        return ScriptingEngine.filesInGit(remote, ScriptingEngine.getFullBranch(remote), null);
    }

    public static String getUserIdOfGist(String id) throws Exception {
        ScriptingEngine.waitForLogin();
        Log.debug((String)("Loading Gist: " + id));
        GHGist gist = PasswordManager.getGithub().getGist(id);
        return gist.getOwner().getLogin();
    }

    public static File createFile(String git, String fileName, String commitMessage) throws Exception {
        ScriptingEngine.pushCodeToGit(git, ScriptingEngine.getFullBranch(git), fileName, null, commitMessage);
        return ScriptingEngine.fileFromGit(git, fileName);
    }

    public static void pushCodeToGit(String id, String branch, String FileName, String content, String commitMessage) throws Exception {
        if (PasswordManager.getUsername() == null) {
            ScriptingEngine.login();
        }
        if (!ScriptingEngine.hasNetwork()) {
            return;
        }
        File gistDir = ScriptingEngine.cloneRepo(id, branch);
        File desired = new File(gistDir.getAbsoluteFile() + "/" + FileName);
        boolean flagNewFile = false;
        if (!desired.exists()) {
            desired.createNewFile();
            flagNewFile = true;
        }
        ScriptingEngine.pushCodeToGit(id, branch, FileName, content, commitMessage, flagNewFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit(String id, String branch, String FileName, String content, String commitMessage, boolean flagNewFile) throws Exception {
        if (PasswordManager.getUsername() == null) {
            ScriptingEngine.login();
        }
        if (!ScriptingEngine.hasNetwork()) {
            return;
        }
        File gistDir = ScriptingEngine.cloneRepo(id, branch);
        File desired = new File(gistDir.getAbsoluteFile() + "/" + FileName);
        String localPath = gistDir.getAbsolutePath();
        File gitRepoFile = new File(localPath + "/.git");
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        Git git = new Git((Repository)localRepo);
        try {
            if (flagNewFile) {
                git.add().addFilepattern(FileName).call();
            }
            if (content != null) {
                FileOutputStream out = null;
                try {
                    out = FileUtils.openOutputStream((File)desired, (boolean)false);
                    IOUtils.write((String)content, (OutputStream)out);
                    ((OutputStream)out).close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            git.commit().setAll(true).setMessage(commitMessage).call();
        }
        catch (Exception ex) {
            git.close();
            throw ex;
        }
        git.close();
        try {
            if (!desired.getName().contentEquals("csgDatabase.json")) {
                String[] gitID = ScriptingEngine.findGitTagFromFile(desired);
                String remoteURI = gitID[0];
                ArrayList<String> f = ScriptingEngine.filesInGit(remoteURI);
                for (String s : f) {
                    if (!s.contentEquals("csgDatabase.json")) continue;
                    File dbFile = ScriptingEngine.fileFromGit(gitID[0], s);
                    if (!CSGDatabase.getDbFile().equals(dbFile)) {
                        CSGDatabase.setDbFile((File)dbFile);
                    }
                    CSGDatabase.saveDatabase();
                    String c = new Scanner(dbFile).useDelimiter("\\Z").next();
                    ScriptingEngine.commit(remoteURI, branch, s, c, "saving CSG database", false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushCodeToGit(String id, String branch, String FileName, String content, String commitMessage, boolean flagNewFile) throws Exception {
        ScriptingEngine.commit(id, branch, FileName, content, commitMessage, flagNewFile);
        if (PasswordManager.getUsername() == null) {
            ScriptingEngine.login();
        }
        if (!ScriptingEngine.hasNetwork()) {
            return;
        }
        File gistDir = ScriptingEngine.cloneRepo(id, branch);
        File desired = new File(gistDir.getAbsoluteFile() + "/" + FileName);
        if (!PasswordManager.hasNetwork() && content != null) {
            FileOutputStream out = null;
            try {
                out = FileUtils.openOutputStream((File)desired, (boolean)false);
                IOUtils.write((String)content, (OutputStream)out);
                ((OutputStream)out).close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            return;
        }
        ScriptingEngine.waitForLogin();
        String localPath = gistDir.getAbsolutePath();
        File gitRepoFile = new File(localPath + "/.git");
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        Git git = new Git((Repository)localRepo);
        try {
            try {
                ((PullCommand)git.pull().setCredentialsProvider(PasswordManager.getCredentialProvider())).call();
            }
            catch (RefNotAdvertisedException ex) {
                System.out.println("Creating new branch master in " + id);
            }
            if (flagNewFile) {
                git.add().addFilepattern(FileName).call();
            }
            if (content != null) {
                FileOutputStream out = null;
                try {
                    out = FileUtils.openOutputStream((File)desired, (boolean)false);
                    IOUtils.write((String)content, (OutputStream)out);
                    ((OutputStream)out).close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            ((PushCommand)git.push().setCredentialsProvider(PasswordManager.getCredentialProvider())).call();
            System.out.println("PUSH OK! file: " + desired);
        }
        catch (Exception ex) {
            String[] gitID = ScriptingEngine.findGitTagFromFile(desired);
            String remoteURI = gitID[0];
            ScriptingEngine.deleteRepo(remoteURI);
            git.close();
            throw ex;
        }
        git.close();
    }

    public static String[] codeFromGit(String id, String FileName) throws Exception {
        File targetFile = ScriptingEngine.fileFromGit(id, FileName);
        if (targetFile.exists()) {
            String text = new String(Files.readAllBytes(Paths.get(targetFile.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
            return new String[]{text, FileName, targetFile.getAbsolutePath()};
        }
        return null;
    }

    private static String[] codeFromGistID(String id, String FileName) throws Exception {
        String giturl = "https://gist.github.com/" + id + ".git";
        File targetFile = ScriptingEngine.fileFromGit(giturl, FileName);
        if (targetFile.exists()) {
            System.err.println("Gist at GIT : " + giturl);
            String text = new String(Files.readAllBytes(Paths.get(targetFile.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
            return new String[]{text, FileName, targetFile.getAbsolutePath()};
        }
        return null;
    }

    public static Object inlineFileScriptRun(File f, ArrayList<Object> args) throws Exception {
        return ScriptingEngine.inlineScriptRun(f, args, ScriptingEngine.getShellType(f.getName()));
    }

    public static Object inlineGistScriptRun(String gistID, String Filename, ArrayList<Object> args) throws Exception {
        String[] gistData = ScriptingEngine.codeFromGistID(gistID, Filename);
        return ScriptingEngine.inlineScriptRun(new File(gistData[2]), args, ScriptingEngine.getShellType(gistData[1]));
    }

    public static Object gitScriptRun(String gitURL, String Filename, ArrayList<Object> args) throws Exception {
        String[] gistData = ScriptingEngine.codeFromGit(gitURL, Filename);
        return ScriptingEngine.inlineScriptRun(new File(gistData[2]), args, ScriptingEngine.getShellType(gistData[1]));
    }

    public static File fileFromGit(String remoteURI, String fileInRepo) throws InvalidRemoteException, TransportException, GitAPIException, IOException {
        return ScriptingEngine.fileFromGit(remoteURI, ScriptingEngine.getFullBranch(remoteURI), fileInRepo);
    }

    public static File fileFromGit(String remoteURI, String branch, String fileInRepo) throws InvalidRemoteException, TransportException, GitAPIException, IOException {
        File gitRepoFile = ScriptingEngine.cloneRepo(remoteURI, branch);
        String id = gitRepoFile.getAbsolutePath();
        if (fileLastLoaded.get(id) == null) {
            fileLastLoaded.put(id, System.currentTimeMillis() - 200000L);
        }
        long lastTime = fileLastLoaded.get(id);
        if (System.currentTimeMillis() - lastTime > 100000L || !gitRepoFile.exists()) {
            fileLastLoaded.put(id, System.currentTimeMillis());
            if (ScriptingEngine.isAutoupdate()) {
                try {
                    FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile() + "/.git");
                    try {
                        ScriptingEngine.pull(remoteURI, branch);
                    }
                    catch (Exception ex) {
                        try {
                            ex.printStackTrace();
                            System.err.println("Error in gist, hosing: " + gitRepoFile);
                            ScriptingEngine.deleteFolder(gitRepoFile);
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                }
                catch (NullPointerException ex) {
                    ScriptingEngine.setAutoupdate(false);
                }
            }
        }
        return new File(gitRepoFile.getAbsolutePath() + "/" + fileInRepo);
    }

    public static File uriToFile(String remoteURI) {
        String[] colinSplit = remoteURI.split(":");
        String gitSplit = colinSplit[1].substring(0, colinSplit[1].lastIndexOf(46));
        File gistDir = new File(ScriptingEngine.getWorkspace().getAbsolutePath() + "/gitcache/" + gitSplit + "/.git");
        return gistDir;
    }

    public static String getBranch(String remoteURI) throws IOException {
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists()) {
            gitRepoFile = ScriptingEngine.cloneRepo(remoteURI, null);
        }
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        String branch = localRepo.getBranch();
        localRepo.close();
        return branch;
    }

    public static String getFullBranch(String remoteURI) throws IOException {
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists()) {
            gitRepoFile = ScriptingEngine.cloneRepo(remoteURI, null);
        }
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        String branch = localRepo.getFullBranch();
        localRepo.close();
        return branch;
    }

    public static void deleteBranch(String remoteURI, String toDelete) throws Exception {
        boolean found = false;
        for (String s : ScriptingEngine.listBranchNames(remoteURI)) {
            if (!s.contains(toDelete)) continue;
            found = true;
        }
        if (!found) {
            throw new RuntimeException(toDelete + " can not be deleted because it does not exist");
        }
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists()) {
            gitRepoFile = ScriptingEngine.cloneRepo(remoteURI, null);
        }
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        Git git = new Git((Repository)localRepo);
        if (!toDelete.contains("heads")) {
            toDelete = "heads/" + toDelete;
        }
        if (!toDelete.contains("refs")) {
            toDelete = "refs/" + toDelete;
        }
        Exception ex = null;
        try {
            git.branchDelete().setBranchNames(new String[]{toDelete}).call();
            RefSpec refSpec = new RefSpec().setSource(null).setDestination(toDelete);
            ((PushCommand)git.push().setRefSpecs(new RefSpec[]{refSpec}).setRemote("origin").setCredentialsProvider(PasswordManager.getCredentialProvider())).call();
        }
        catch (Exception e) {
            ex = e;
        }
        git.close();
        if (ex != null) {
            throw ex;
        }
    }

    public static void newBranch(String remoteURI, String newBranch) throws Exception {
        for (String s : ScriptingEngine.listBranchNames(remoteURI)) {
            if (!s.contains(newBranch)) continue;
            throw new RuntimeException(newBranch + " can not be created because " + s + " is too similar");
        }
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists()) {
            gitRepoFile = ScriptingEngine.cloneRepo(remoteURI, null);
        }
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        String source = ScriptingEngine.getFullBranch(remoteURI);
        Git git = new Git((Repository)localRepo);
        ScriptingEngine.newBranchLocal(newBranch, source, git);
        git.close();
    }

    private static void newBranchLocal(String newBranch, String remoteURI, Git git) throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException, InvalidRemoteException, TransportException, IOException {
        String source = ScriptingEngine.getFullBranch(remoteURI);
        try {
            CreateBranchCommand setName = git.branchCreate().setName(newBranch);
            CreateBranchCommand setStartPoint = setName.setStartPoint(source);
            CreateBranchCommand setForce = setStartPoint.setForce(true);
            setForce.call();
        }
        catch (RefNotFoundException ex) {
            git.branchCreate().setName(newBranch).call();
        }
        PushCommand pushCommand = git.push();
        PushCommand setRemote = pushCommand.setRemote("origin");
        PushCommand setRefSpecs = setRemote.setRefSpecs(new RefSpec[]{new RefSpec(newBranch + ":" + newBranch)});
        PushCommand setCredentialsProvider = (PushCommand)setRefSpecs.setCredentialsProvider(PasswordManager.getCredentialProvider());
        setCredentialsProvider.call();
        CheckoutCommand checkout = git.checkout();
        checkout.setName(newBranch);
        checkout.call();
    }

    private static boolean hasAtLeastOneReference(Git git) throws Exception {
        Repository repo = git.getRepository();
        StoredConfig storedConfig = repo.getConfig();
        Set uriList = repo.getConfig().getSubsections("remote");
        String remoteURI = null;
        for (String remoteName : uriList) {
            if (remoteURI != null) continue;
            remoteURI = storedConfig.getString("remote", remoteName, "url");
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + 2000L) {
            for (Ref ref : repo.getAllRefs().values()) {
                List<Ref> branchList;
                if (ref.getObjectId() == null || (branchList = ScriptingEngine.listBranches(remoteURI, git)).size() <= 0) continue;
                return true;
            }
        }
        return true;
    }

    public static List<Ref> listBranches(String remoteURI) throws Exception {
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists()) {
            gitRepoFile = ScriptingEngine.cloneRepo(remoteURI, null);
            return ScriptingEngine.listBranches(remoteURI);
        }
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        ArrayList<Ref> Ret = new ArrayList();
        Git git = new Git((Repository)localRepo);
        Ret = ScriptingEngine.listBranches(remoteURI, git);
        git.close();
        return Ret;
    }

    public static List<Ref> listBranches(String remoteURI, Git git) throws Exception {
        List list = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        return list;
    }

    public static List<Ref> listLocalBranches(String remoteURI) throws IOException {
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists()) {
            gitRepoFile = ScriptingEngine.cloneRepo(remoteURI, null);
        }
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        Git git = new Git((Repository)localRepo);
        try {
            List list = git.branchList().call();
            git.close();
            return list;
        }
        catch (Exception exception) {
            git.close();
            return new ArrayList<Ref>();
        }
    }

    public static List<String> listLocalBranchNames(String remoteURI) throws Exception {
        ArrayList<String> branchNames = new ArrayList<String>();
        List<Ref> list = ScriptingEngine.listLocalBranches(remoteURI);
        for (Ref ref : list) {
            branchNames.add(ref.getName());
        }
        return branchNames;
    }

    public static List<String> listBranchNames(String remoteURI) throws Exception {
        ArrayList<String> branchNames = new ArrayList<String>();
        List<Ref> list = ScriptingEngine.listBranches(remoteURI);
        for (Ref ref : list) {
            branchNames.add(ref.getName());
        }
        return branchNames;
    }

    public static void pull(String remoteURI, String branch) throws IOException {
        if (!ScriptingEngine.hasNetwork()) {
            return;
        }
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists()) {
            gitRepoFile = ScriptingEngine.cloneRepo(remoteURI, branch);
        }
        FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile());
        Git git = new Git((Repository)localRepo);
        try {
            System.out.print("Pulling " + remoteURI);
            PullResult result = ((PullCommand)git.pull().setCredentialsProvider(PasswordManager.getCredentialProvider())).call();
            System.out.println(" ... Success!");
        }
        catch (CheckoutConflictException ex) {
            for (String p : ex.getConflictingPaths()) {
                File conf = new File(gitRepoFile.getParent() + "/" + p);
                System.out.println("\r\nConflict: " + conf);
                System.out.println("Using upstream and deleting local changes");
                if (!conf.exists()) continue;
                FileChangeWatcher.close(conf);
                conf.delete();
            }
            git.close();
            ScriptingEngine.pull(remoteURI, branch);
        }
        catch (WrongRepositoryStateException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        catch (DetachedHeadException e) {
            e.printStackTrace();
        }
        catch (InvalidRemoteException e) {
            e.printStackTrace();
        }
        catch (CanceledException e) {
            e.printStackTrace();
        }
        catch (RefNotFoundException e) {
            e.printStackTrace();
        }
        catch (RefNotAdvertisedException e) {
            e.printStackTrace();
        }
        catch (NoHeadException e) {
            e.printStackTrace();
        }
        catch (TransportException e) {
            e.printStackTrace();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
        git.close();
    }

    public static void pull(String remoteURI) throws IOException {
        if (!ScriptingEngine.hasNetwork()) {
            return;
        }
        ScriptingEngine.pull(remoteURI, ScriptingEngine.getBranch(remoteURI));
    }

    public static void checkoutCommit(String remoteURI, String branch, String commitHash) throws IOException {
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists() || !gitRepoFile.getAbsolutePath().endsWith(".git")) {
            System.err.println("Invailid git file!" + gitRepoFile.getAbsolutePath());
            throw new RuntimeException("Invailid git file!" + gitRepoFile.getAbsolutePath());
        }
        FileRepository localRepo = new FileRepository(gitRepoFile);
        Git git = new Git((Repository)localRepo);
        try {
            git.checkout().setName(commitHash).call();
            git.checkout().setCreateBranch(true).setName(branch).setStartPoint(commitHash).call();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        git.close();
    }

    public static void checkout(String remoteURI, String branch) throws IOException {
        File gitRepoFile = ScriptingEngine.uriToFile(remoteURI);
        if (!gitRepoFile.exists() || !gitRepoFile.getAbsolutePath().endsWith(".git")) {
            System.err.println("Invailid git file!" + gitRepoFile.getAbsolutePath());
            throw new RuntimeException("Invailid git file!" + gitRepoFile.getAbsolutePath());
        }
        String currentBranch = ScriptingEngine.getFullBranch(remoteURI);
        if (currentBranch != null) {
            FileRepository localRepo = new FileRepository(gitRepoFile);
            if (!currentBranch.contains(branch)) {
                ScriptingEngine.pull(remoteURI, branch);
                Git git = new Git((Repository)localRepo);
                try {
                    git.branchCreate().setForce(true).setName(branch).setStartPoint("origin/" + branch).call();
                    git.checkout().setName(branch).call();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                git.close();
            }
        }
    }

    public static File cloneRepo(String remoteURI, String branch) {
        String[] colinSplit = remoteURI.split(":");
        String gitSplit = colinSplit[1].substring(0, colinSplit[1].lastIndexOf(46));
        File gistDir = new File(ScriptingEngine.getWorkspace().getAbsolutePath() + "/gitcache/" + gitSplit);
        if (!gistDir.exists()) {
            gistDir.mkdir();
        }
        String localPath = gistDir.getAbsolutePath();
        File gitRepoFile = new File(localPath + "/.git");
        File dir = new File(localPath);
        if (!gitRepoFile.exists()) {
            if (!ScriptingEngine.hasNetwork()) {
                return null;
            }
            System.out.println("Cloning files from: " + remoteURI);
            if (branch != null) {
                System.out.println("            branch: " + branch);
            }
            System.out.println("                to: " + localPath);
            for (int i = 0; i < 5; ++i) {
                try {
                    if (branch == null) {
                        Git git = ((CloneCommand)Git.cloneRepository().setURI(remoteURI).setDirectory(dir).setCredentialsProvider(PasswordManager.getCredentialProvider())).call();
                        ScriptingEngine.hasAtLeastOneReference(git);
                        branch = ScriptingEngine.getFullBranch(remoteURI);
                        ScriptingEngine.checkout(remoteURI, branch);
                        ScriptingEngine.hasAtLeastOneReference(git);
                        git.close();
                        break;
                    }
                    Git git = ((CloneCommand)Git.cloneRepository().setURI(remoteURI).setBranch(branch).setDirectory(dir).setCredentialsProvider(PasswordManager.getCredentialProvider())).call();
                    ScriptingEngine.hasAtLeastOneReference(git);
                    ScriptingEngine.checkout(remoteURI, branch);
                    ScriptingEngine.hasAtLeastOneReference(git);
                    git.close();
                    break;
                }
                catch (Exception e) {
                    Log.error((String)("Failed to clone " + remoteURI + " " + e));
                    e.printStackTrace();
                    ScriptingEngine.deleteFolder(new File(localPath));
                    ThreadUtil.wait((int)(200 * i));
                    continue;
                }
            }
        }
        if (branch != null) {
            try {
                ScriptingEngine.checkout(remoteURI, branch);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return gistDir;
    }

    public static Git locateGit(File f) throws IOException {
        File gitRepoFile = f;
        while (gitRepoFile != null) {
            if (!new File((gitRepoFile = gitRepoFile.getParentFile()).getAbsolutePath() + "/.git").exists()) continue;
            FileRepository localRepo = new FileRepository(gitRepoFile.getAbsoluteFile() + "/.git");
            return new Git((Repository)localRepo);
        }
        return null;
    }

    public static String getText(URL website) throws Exception {
        String inputLine;
        URLConnection connection = website.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine + "\n");
        }
        in.close();
        return response.toString();
    }

    public static File getLastFile() {
        if (lastFile == null) {
            return ScriptingEngine.getWorkspace();
        }
        return lastFile;
    }

    public static void setLastFile(File lastFile) {
        ScriptingEngine.lastFile = lastFile;
    }

    public static File getFileEngineRunByName(String filename) {
        return filesRun.get(filename);
    }

    public static String[] getImports() {
        return imports;
    }

    public static IGitHubLoginManager getLoginManager() {
        return PasswordManager.getLoginManager();
    }

    public static void setLoginManager(IGitHubLoginManager lm) {
        PasswordManager.setLoginManager(lm);
    }

    public static boolean isAutoupdate() {
        return autoupdate;
    }

    public static boolean setAutoupdate(boolean autoupdate) throws IOException {
        if (autoupdate && !ScriptingEngine.autoupdate) {
            ScriptingEngine.autoupdate = true;
        }
        ScriptingEngine.autoupdate = autoupdate;
        return ScriptingEngine.autoupdate;
    }

    private static File fileFromGistID(String string, String string2) throws InvalidRemoteException, TransportException, GitAPIException, IOException {
        return ScriptingEngine.fileFromGit("https://gist.github.com/" + string + ".git", string2);
    }

    public static String findLocalPath(File currentFile, Git git) {
        File dir = git.getRepository().getDirectory().getParentFile();
        return dir.toURI().relativize(currentFile.toURI()).getPath();
    }

    public static String findLocalPath(File currentFile) {
        try {
            Git git = ScriptingEngine.locateGit(currentFile);
            return ScriptingEngine.findLocalPath(currentFile, git);
        }
        catch (IOException e) {
            e.printStackTrace();
            return currentFile.getName();
        }
    }

    public static String[] findGitTagFromFile(File currentFile) throws IOException {
        Git git = ScriptingEngine.locateGit(currentFile);
        return new String[]{git.getRepository().getConfig().getString("remote", "origin", "url"), ScriptingEngine.findLocalPath(currentFile, git)};
    }

    public static boolean checkOwner(File currentFile) {
        try {
            ScriptingEngine.waitForLogin();
            Git git = ScriptingEngine.locateGit(currentFile);
            ((PullCommand)git.pull().setCredentialsProvider(PasswordManager.getCredentialProvider())).call();
            ((PushCommand)git.push().setCredentialsProvider(PasswordManager.getCredentialProvider())).call();
            git.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static GHGist fork(String currentGist) throws Exception {
        if (PasswordManager.getGithub() != null) {
            ScriptingEngine.waitForLogin();
            GHGist incoming = PasswordManager.getGithub().getGist(currentGist);
            for (IGithubLoginListener l : loginListeners) {
                l.onLogin(PasswordManager.getUsername());
            }
            return incoming.fork();
        }
        return null;
    }

    public static String[] forkGitFile(String[] incoming) throws Exception {
        GitHub github = PasswordManager.getGithub();
        String id = null;
        if (incoming[0].endsWith(".git")) {
            id = ScriptingEngine.urlToGist(incoming[0]);
        } else {
            id = incoming[0];
            incoming[0] = "https://gist.github.com/" + id + ".git";
        }
        GHGist incomingGist = github.getGist(id);
        File incomingFile = ScriptingEngine.fileFromGistID(id, incoming[1]);
        if (!ScriptingEngine.checkOwner(incomingFile)) {
            incomingGist = incomingGist.fork();
            incoming[0] = "https://gist.github.com/" + ScriptingEngine.urlToGist(incomingGist.getHtmlUrl()) + ".git";
            incomingFile = ScriptingEngine.fileFromGistID(id, incoming[1]);
        }
        for (IGithubLoginListener l : loginListeners) {
            l.onLogin(PasswordManager.getUsername());
        }
        return incoming;
    }

    public static List<String> getAllLangauges() {
        ArrayList<String> langs = new ArrayList<String>();
        for (String L : ScriptingEngine.getLangaugesMap().keySet()) {
            langs.add(L);
        }
        return langs;
    }

    public static HashMap<String, IScriptingLanguage> getLangaugesMap() {
        return langauges;
    }

    public static boolean hasNetwork() {
        return PasswordManager.hasNetwork();
    }

    public static boolean isLoginSuccess() {
        return PasswordManager.loggedIn();
    }

    public static String[] copyGitFile(String sourceGit, String targetGit, String filename) {
        String targetFilename = filename;
        if (targetGit.contains("gist.github.com") && filename.contains("/")) {
            String[] parts = filename.split("/");
            targetFilename = parts[parts.length - 1];
        }
        try {
            String[] WalkingEngine;
            block16: {
                WalkingEngine = ScriptingEngine.codeFromGit(sourceGit, filename);
                try {
                    if (null != ScriptingEngine.fileFromGit(targetGit, targetFilename)) break block16;
                    ScriptingEngine.createFile(targetGit, targetFilename, "copy file");
                    while (true) {
                        try {
                            ScriptingEngine.fileFromGit(targetGit, targetFilename);
                        }
                        catch (Exception parts) {
                            ThreadUtil.wait((int)500);
                            continue;
                        }
                        break;
                    }
                }
                catch (InvalidRemoteException e) {
                    e.printStackTrace();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
                catch (GitAPIException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                String[] newFileCode = ScriptingEngine.codeFromGit(targetGit, targetFilename);
                if (newFileCode == null) {
                    newFileCode = new String[]{""};
                }
                if (!WalkingEngine[0].contentEquals(newFileCode[0])) {
                    System.out.println("Copy Content to " + targetGit + "/" + targetFilename);
                    ScriptingEngine.pushCodeToGit(targetGit, ScriptingEngine.getFullBranch(targetGit), targetFilename, WalkingEngine[0], "copy file content");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return new String[]{targetGit, targetFilename};
    }

    static {
        File oldpass;
        fileLastLoaded = new HashMap<String, Long>();
        autoupdate = false;
        imports = new String[]{"java.nio.file", "java.util", "java.awt.image", "javafx.scene.text", "javafx.scene", "javafx.scene.control", "eu.mihosoft.vrl.v3d", "eu.mihosoft.vrl.v3d.svg", "eu.mihosoft.vrl.v3d.samples", "eu.mihosoft.vrl.v3d.parametrics", "com.neuronrobotics.imageprovider", "com.neuronrobotics.sdk.addons.kinematics.xml", "com.neuronrobotics.sdk.addons.kinematics", "com.neuronrobotics.sdk.dyio.peripherals", "com.neuronrobotics.sdk.dyio", "com.neuronrobotics.sdk.common", "com.neuronrobotics.sdk.ui", "com.neuronrobotics.sdk.util", "com.neuronrobotics.sdk.serial", "com.neuronrobotics.sdk.addons.kinematics", "com.neuronrobotics.sdk.addons.kinematics.math", "com.neuronrobotics.sdk.addons.kinematics.gui", "com.neuronrobotics.sdk.config", "com.neuronrobotics.bowlerkernel", "com.neuronrobotics.bowlerstudio", "com.neuronrobotics.bowlerstudio.scripting", "com.neuronrobotics.bowlerstudio.tabs", "com.neuronrobotics.bowlerstudio.physics", "com.neuronrobotics.bowlerstudio.physics", "com.neuronrobotics.bowlerstudio.vitamins", "com.neuronrobotics.bowlerstudio.creature", "com.neuronrobotics.bowlerstudio.threed"};
        filesRun = new HashMap();
        loginListeners = new ArrayList();
        langauges = new HashMap();
        PasswordManager.hasNetwork();
        workspace = new File(System.getProperty("user.home") + "/bowler-workspace/");
        if (!workspace.exists()) {
            workspace.mkdir();
        }
        if ((oldpass = new File(System.getProperty("user.home") + "/.github")).exists()) {
            oldpass.delete();
        }
        try {
            PasswordManager.loadLoginData(workspace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ScriptingEngine.addScriptingLanguage(new ClojureHelper());
        ScriptingEngine.addScriptingLanguage(new GroovyHelper());
        ScriptingEngine.addScriptingLanguage(new JythonHelper());
        ScriptingEngine.addScriptingLanguage(new RobotHelper());
        ScriptingEngine.addScriptingLanguage(new JsonRunner());
        ScriptingEngine.addScriptingLanguage(new ArduinoLoader());
    }
}

