/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.wizard;

import de.miethxml.toolkit.ui.GradientLabel;
import de.miethxml.toolkit.ui.TopLineBorder;
import de.miethxml.toolkit.wizard.WizardComponent;
import de.miethxml.toolkit.wizard.WizardConfiguration;
import de.miethxml.toolkit.wizard.WizardConstants;
import de.miethxml.toolkit.wizard.WizardException;
import de.miethxml.toolkit.wizard.event.VetoException;
import de.miethxml.toolkit.wizard.event.WizardListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class WizardManager {
    public static String ACTION_NEXT = "next";
    public static String ACTION_PREVIOUS = "previous";
    public static String ACTION_CANCEL = "cancel";
    public static String ACTION_SKIP = "skip";
    public static String ACTION_QUIT = "quit";
    private ArrayList components = new ArrayList();
    private WizardConfiguration conf = new WizardConfiguration();
    private WizardComponent currentComponent;
    private int currentStep = -1;
    private JPanel panel;
    private JButton nextButton;
    private JButton previousButton;
    private JButton skipButton;
    private GradientLabel titleLabel;
    private CardLayout cardLayout;
    private JPanel componentPanel;
    private Controller controller;
    private Thread worker;
    private boolean stopped = false;
    private ArrayList listener = new ArrayList();
    private ResourceBundle resource = WizardConstants.LOCALE;
    private double buttonPanelHeight;

    static {
        if (WizardConstants.LOCALE == null) {
            WizardConstants.LOCALE = PropertyResourceBundle.getBundle("resources.labels");
        }
    }

    public void addWizardComponent(WizardComponent comp) {
        comp.setWizardConfiguration(this.conf);
        JComponent view = comp.getInstallUIComponent();
        this.componentPanel.add((Component)view, "" + this.components.size());
        this.components.add(comp);
        Dimension dim = view.getPreferredSize();
        double width = dim.getWidth();
        double height = this.titleLabel.getPreferredSize().getHeight() + dim.getHeight() + this.buttonPanelHeight;
        System.out.println("from comp:" + dim);
        if (this.panel.getPreferredSize().getWidth() > width) {
            width = this.panel.getPreferredSize().getWidth();
        }
        if (this.panel.getPreferredSize().getHeight() > height) {
            height = this.panel.getPreferredSize().getHeight();
        }
        this.panel.setPreferredSize(new Dimension((int)width, (int)height));
        System.out.println("set View:" + this.panel.getPreferredSize());
    }

    public JComponent getView() {
        return this.panel;
    }

    public void initialize() {
        this.panel = new JPanel(new BorderLayout());
        this.controller = new Controller();
        this.titleLabel = new GradientLabel("");
        this.panel.add((Component)this.titleLabel, "North");
        this.cardLayout = new CardLayout();
        this.componentPanel = new JPanel(this.cardLayout);
        this.panel.add((Component)this.componentPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setBorder(new TopLineBorder());
        this.previousButton = new JButton(this.resource.getString("common.previous"));
        this.previousButton.setActionCommand(ACTION_PREVIOUS);
        this.previousButton.addActionListener(this.controller);
        this.previousButton.setEnabled(false);
        buttonPanel.add(this.previousButton);
        this.nextButton = new JButton(this.resource.getString("common.next"));
        this.nextButton.setActionCommand(ACTION_NEXT);
        this.nextButton.addActionListener(this.controller);
        buttonPanel.add(this.nextButton);
        this.skipButton = new JButton(this.resource.getString("common.skip"));
        this.skipButton.setActionCommand(ACTION_SKIP);
        this.skipButton.addActionListener(this.controller);
        buttonPanel.add(this.skipButton);
        this.buttonPanelHeight = buttonPanel.getPreferredSize().getHeight();
        this.panel.add((Component)buttonPanel, "South");
    }

    public void start() {
        this.nextInstallComponent();
    }

    private void processNextInstallComponent() {
        this.stopped = false;
        this.worker = new Thread(new Runnable(){

            public void run() {
                try {
                    WizardManager.this.currentComponent.startWizardProcess();
                    if (!WizardManager.this.stopped) {
                        WizardManager.this.nextButton.setText(WizardManager.this.resource.getString("common.next"));
                        WizardManager.this.nextButton.setActionCommand(ACTION_NEXT);
                        WizardManager.this.nextInstallComponent();
                    }
                }
                catch (WizardException e) {
                    JOptionPane.showMessageDialog(null, String.valueOf(WizardManager.this.resource.getString("installer.error.message")) + e.getLocalizedMessage());
                }
            }
        });
        this.worker.start();
        this.nextButton.setText(this.resource.getString("common.cancel"));
        this.nextButton.setActionCommand(ACTION_CANCEL);
    }

    private void stopProcessing() {
        try {
            this.currentComponent.stopWizardProcess();
        }
        catch (WizardException e) {
            this.worker.stop();
        }
        this.stopped = true;
        this.nextButton.setText(this.resource.getString("common.next"));
        this.nextButton.setActionCommand(ACTION_NEXT);
    }

    private void nextInstallComponent() {
        ++this.currentStep;
        if (this.currentStep < this.components.size()) {
            this.skipButton.setText(this.resource.getString("common.skip"));
            this.skipButton.setActionCommand(ACTION_SKIP);
            this.currentComponent = (WizardComponent)this.components.get(this.currentStep);
            this.titleLabel.setText(this.currentComponent.getTitle());
            this.cardLayout.show(this.componentPanel, "" + this.currentStep);
            if (this.currentStep > 0) {
                this.previousButton.setEnabled(true);
            }
            if (this.currentComponent.isModifiable()) {
                this.nextButton.setEnabled(true);
            } else {
                this.nextButton.setEnabled(false);
                this.processNextInstallComponent();
            }
        } else {
            this.fireEndInstallationEvent();
            this.skipButton.setText(this.resource.getString("common.quit"));
            this.skipButton.setActionCommand(ACTION_QUIT);
            this.nextButton.setEnabled(false);
            --this.currentStep;
        }
    }

    private void previousInstallComponent() {
        this.stopProcessing();
        if (this.currentStep > 0) {
            if (this.currentStep == this.components.size() - 1) {
                this.skipButton.setText(this.resource.getString("common.skip"));
                this.skipButton.setActionCommand(ACTION_SKIP);
            }
            --this.currentStep;
            this.currentComponent = (WizardComponent)this.components.get(this.currentStep);
            this.titleLabel.setText(this.currentComponent.getTitle());
            this.cardLayout.show(this.componentPanel, "" + this.currentStep);
            this.nextButton.setText(this.resource.getString("common.next"));
            this.nextButton.setActionCommand(ACTION_NEXT);
            this.nextButton.setEnabled(true);
        }
    }

    public WizardConfiguration getWizardConfiguration() {
        return this.conf;
    }

    public void setWizardConfiguration(WizardConfiguration conf) {
        this.conf = conf;
        if (this.components.size() > 0) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                WizardComponent comp = (WizardComponent)i.next();
                comp.setWizardConfiguration(conf);
            }
        }
    }

    public void addInstallerListener(WizardListener l) {
        this.listener.add(l);
    }

    public void removeInstallerListener(WizardListener l) {
        this.listener.remove(l);
    }

    private void fireStartInstallationEvent() {
        Iterator i = this.listener.iterator();
        while (i.hasNext()) {
            WizardListener l = (WizardListener)i.next();
            l.startInstallation();
        }
    }

    private void fireEndInstallationEvent() {
        Iterator i = this.listener.iterator();
        while (i.hasNext()) {
            WizardListener l = (WizardListener)i.next();
            l.endInstallation();
        }
    }

    private void fireQuitInstallationEvent() {
        Iterator i = this.listener.iterator();
        while (i.hasNext()) {
            WizardListener l = (WizardListener)i.next();
            try {
                l.quitInstallation();
            }
            catch (VetoException e) {
                return;
            }
        }
        System.exit(0);
    }

    public void showInstallComponent(int index) {
        this.currentStep = index - 1;
        this.nextInstallComponent();
    }

    private class Controller
    implements ActionListener {
        Controller() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(ACTION_NEXT)) {
                WizardManager.this.processNextInstallComponent();
            } else if (cmd.equals(ACTION_CANCEL)) {
                WizardManager.this.stopProcessing();
            } else if (cmd.equals(ACTION_PREVIOUS)) {
                WizardManager.this.previousInstallComponent();
            } else if (cmd.equals(ACTION_SKIP)) {
                WizardManager.this.stopProcessing();
                WizardManager.this.nextInstallComponent();
            } else if (cmd.equals(ACTION_QUIT)) {
                WizardManager.this.fireQuitInstallationEvent();
            }
        }
    }
}

