/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.wizard.ui;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JLabel;

public class TimerUI
implements Runnable {
    private long start;
    private long current;
    private boolean go = false;
    private JLabel label;
    private Thread t;
    private SimpleDateFormat dateformat = new SimpleDateFormat("HH:mm:ss");
    private Date date;
    private int count;
    private int maxCount;

    public TimerUI() {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        this.dateformat.setTimeZone(tz);
        this.date = new Date();
    }

    public void run() {
        while (this.go) {
            long time = System.currentTimeMillis() - this.start;
            long left = (long)(this.maxCount - this.count) * time / (long)this.count;
            this.date.setTime(left);
            this.label.setText(this.dateformat.format(this.date));
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void begin(JLabel label, int maxCount) {
        this.label = label;
        this.start = System.currentTimeMillis();
        this.go = true;
        this.maxCount = maxCount + 1;
        this.count = 1;
        this.t = new Thread(this);
        this.t.start();
    }

    public void end() {
        this.go = false;
    }

    public void next() {
        ++this.count;
    }

    public void setValue(int count) {
        this.count = count;
    }
}

