/*
 * Decompiled with CFR 0.152.
 */
package com.piro.bezier;

import com.piro.bezier.Bezier;
import com.piro.bezier.BezierListProducer;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BezierPath {
    static final Matcher matchPoint = Pattern.compile("\\s*(\\d+)[^\\d]+(\\d+)\\s*").matcher("");
    BezierListProducer path;

    public BezierPath() {
    }

    public BezierPath(String path) {
        this.parsePathString(path);
    }

    public void parsePathString(String d) {
        this.path = new BezierListProducer();
        this.parsePathList(d);
    }

    protected void parsePathList(String list) {
        Matcher matchPathCmd = Pattern.compile("([MmLlHhVvAaQqTtCcSsZz])|([-+]?((\\d*\\.\\d+)|(\\d+))([eE][-+]?\\d+)?)").matcher(list);
        LinkedList<String> tokens = new LinkedList<String>();
        while (matchPathCmd.find()) {
            tokens.addLast(matchPathCmd.group());
        }
        int curCmd = 90;
        block22: while (tokens.size() != 0) {
            String curToken = (String)tokens.removeFirst();
            char initChar = curToken.charAt(0);
            if (initChar >= 'A' && initChar <= 'Z' || initChar >= 'a' && initChar <= 'z') {
                curCmd = initChar;
            } else {
                tokens.addFirst(curToken);
            }
            switch (curCmd) {
                case 77: {
                    this.path.movetoAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    curCmd = 76;
                    continue block22;
                }
                case 109: {
                    this.path.movetoRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    curCmd = 108;
                    continue block22;
                }
                case 76: {
                    this.path.linetoAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 108: {
                    this.path.linetoRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 72: {
                    this.path.linetoHorizontalAbs(BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 104: {
                    this.path.linetoHorizontalRel(BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 86: {
                    this.path.linetoVerticalAbs(BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 118: {
                    this.path.linetoVerticalAbs(BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 65: 
                case 97: {
                    continue block22;
                }
                case 81: {
                    this.path.curvetoQuadraticAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 113: {
                    this.path.curvetoQuadraticAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 84: {
                    this.path.curvetoQuadraticSmoothAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 116: {
                    this.path.curvetoQuadraticSmoothRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 67: {
                    this.path.curvetoCubicAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 99: {
                    this.path.curvetoCubicRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 83: {
                    this.path.curvetoCubicSmoothAbs(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 115: {
                    this.path.curvetoCubicSmoothRel(BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens), BezierPath.nextFloat(tokens));
                    continue block22;
                }
                case 90: 
                case 122: {
                    this.path.closePath();
                    continue block22;
                }
                case 47: {
                    continue block22;
                }
            }
            throw new RuntimeException("Invalid path element");
        }
    }

    protected static float nextFloat(LinkedList<String> l) {
        String s = l.removeFirst();
        return Float.parseFloat(s);
    }

    public Vector3d eval(float interp) {
        Vector3d point = new Vector3d(0.0, 0.0);
        double curLength = this.path.curveLength * interp;
        for (Bezier bez : this.path.bezierSegs) {
            double bezLength = bez.getLength();
            if (curLength < bezLength) {
                double param = curLength / bezLength;
                point = bez.eval(param);
                break;
            }
            curLength -= bezLength;
        }
        return point;
    }
}

