/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.ui.impl;

import com.jgoodies.plaf.BorderStyle;
import com.jgoodies.plaf.plastic.Plastic3DLookAndFeel;
import com.jgoodies.plaf.plastic.PlasticLookAndFeel;
import com.jgoodies.plaf.plastic.PlasticTheme;
import com.jgoodies.plaf.plastic.theme.DesertBlue;
import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.ui.ApplicationFrame;
import de.miethxml.toolkit.ui.MenuBarManager;
import de.miethxml.toolkit.ui.ToolBarManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.tools.ant.Project;

public class MainFrame
implements Serviceable,
Initializable,
Disposable,
Configurable,
ApplicationFrame,
Startable {
    public static final String PARAMETER_LOOK_N_FEEL = "look-and-feel";
    private Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor(this.getClass().getName());
    private ServiceManager serviceManager;
    private ServiceManager manager;
    private MenuBarManager mb;
    private JComponent toolbar;
    private Project project;
    private JComponent desktop;
    private Dimension size;
    private boolean initialized = false;
    private JButton save;
    private String appName = "";
    private JFrame frame;
    private boolean viewAdded = false;
    private String lookNFeel;
    private String title = "";
    private JComponent view;

    public void initialize() {
        try {
            MenuBarManager menubar = (MenuBarManager)this.manager.lookup(MenuBarManager.ROLE);
            ToolBarManager toolbar = (ToolBarManager)this.manager.lookup(ToolBarManager.ROLE);
            this.frame = new JFrame();
            this.frame.setTitle(this.title);
            this.frame.setSize(new Dimension(640, 480));
            this.frame.getContentPane().setLayout(new BorderLayout());
            JMenuBar m = menubar.getMenuBar();
            SwingUtilities.updateComponentTreeUI(m);
            this.frame.setJMenuBar(m);
            JComponent comp = toolbar.getToolBar();
            SwingUtilities.updateComponentTreeUI(comp);
            this.frame.getContentPane().add((Component)comp, "North");
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void addWindowListener(WindowListener l) {
        this.frame.addWindowListener(l);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void setApplicationView(JComponent view) {
        this.view = view;
        JScrollPane sp = new JScrollPane(view);
        sp.setBorder(BorderFactory.createEmptyBorder());
        this.desktop = sp;
        this.frame.getContentPane().add((Component)this.desktop, "Center");
        this.viewAdded = true;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.frame.pack();
        }
        this.frame.setVisible(b);
    }

    public void dispose() {
    }

    private void setLookAndFeel() {
        try {
            if (this.lookNFeel == null) {
                this.lookNFeel = ConfigManager.getInstance().getProperty(PARAMETER_LOOK_N_FEEL);
            }
            if (this.lookNFeel.equals("platform")) {
                String nativeLF = UIManager.getSystemLookAndFeelClassName();
                this.setLookNFeel(nativeLF);
            } else if (this.lookNFeel.length() > 0) {
                this.setLookNFeel(this.lookNFeel);
            } else {
                PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)new DesertBlue());
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                UIManager.put("jgoodies.popupDropShadowEnabled", Boolean.TRUE);
                UIManager.put("Plastic3DLookAndFeel.BORDER_STYLE_KEY", BorderStyle.EMPTY);
                if (this.frame != null) {
                    SwingUtilities.updateComponentTreeUI(this.frame);
                }
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public void setLookNFeel(String value) {
        try {
            UIManager.setLookAndFeel(value);
            if (this.frame != null) {
                SwingUtilities.updateComponentTreeUI(this.frame);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public void start() throws Exception {
        this.setVisible(true);
    }

    public void stop() throws Exception {
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration c = conf.getChild("title");
        if (c != null) {
            this.title = c.getValue();
        }
        if ((c = conf.getChild(PARAMETER_LOOK_N_FEEL)) != null && c.getAttribute("value", null) != null) {
            this.lookNFeel = c.getAttribute("value");
        }
        this.setLookAndFeel();
    }
}

