/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.wizard;

import de.miethxml.toolkit.wizard.WizardComponent;
import de.miethxml.toolkit.wizard.WizardConfiguration;
import de.miethxml.toolkit.wizard.WizardManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class WizardFactory
implements ContentHandler {
    public static String ELEMENT_ROOT = "wizard";
    public static String ELEMENT_CONFIGURATION = "configuration";
    public static String ELEMENT_COMPONENT = "component";
    public static String ELEMENT_PARAMETER = "parameter";
    public static String ELEMENT_VALUE = "value";
    public static String ELEMENT_LIST = "list";
    public static String ELEMENT_ENTRY = "entry";
    public static String ATTRIBUTE_CLASS = "class";
    public static String DEFAULT_CONFIGFILE = "resources/wizard.xconf";
    private WizardManager wizard = new WizardManager();
    private WizardConfiguration conf = new WizardConfiguration();
    private WizardComponent component;
    private WizardConfiguration parent;
    private Hashtable parameters;
    private List list;
    private String value;
    private StringBuffer buffer = new StringBuffer();
    private int CONFIGURATION_MODE = 0;
    private int COMPONENT_MODE = 1;
    private int mode = -1;
    static /* synthetic */ Class class$0;

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.wizard.initialize();
        this.wizard.setWizardConfiguration(this.conf);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals(ELEMENT_ENTRY) && this.mode == this.CONFIGURATION_MODE) {
            System.out.println("add ENTRY:" + this.buffer.toString());
            this.list.add(this.buffer.toString());
        } else if (qName.equals(ELEMENT_VALUE) && this.mode == this.CONFIGURATION_MODE) {
            System.out.println("setValue:" + this.value);
            if (this.list != null) {
                System.out.println("List value:" + this.list);
                this.conf.setValue(this.value, this.list);
            } else {
                System.out.println("textvalue");
                this.conf.setValue(this.value, this.buffer.toString());
            }
        } else if (this.mode == this.CONFIGURATION_MODE) {
            if (this.parent != null) {
                this.conf = this.parent;
            }
        } else if (qName.equals(ELEMENT_CONFIGURATION)) {
            this.mode = -1;
        } else if (qName.equals(ELEMENT_COMPONENT)) {
            this.mode = -1;
            System.out.println("setPARAMETER");
            this.component.setup(this.parameters);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals(ELEMENT_COMPONENT)) {
            String clazzName = atts.getValue(ATTRIBUTE_CLASS);
            this.mode = this.COMPONENT_MODE;
            this.parameters = new Hashtable();
            System.out.println("componentCLASS:" + clazzName);
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(clazzName);
                this.component = (WizardComponent)clazz.newInstance();
                this.wizard.addWizardComponent(this.component);
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (qName.equals(ELEMENT_CONFIGURATION)) {
            this.mode = this.CONFIGURATION_MODE;
            this.processConfigurationAttributes(this.conf, atts);
        } else if (qName.equals(ELEMENT_PARAMETER) && this.mode == this.COMPONENT_MODE) {
            System.out.println("PARAMETER for:" + this.component.getTitle());
            System.out.println("NAME:" + atts.getValue("name") + " VALUE=" + atts.getValue("value"));
            this.parameters.put(atts.getValue("name"), atts.getValue("value"));
        } else if (qName.equals(ELEMENT_VALUE) && this.mode == this.CONFIGURATION_MODE) {
            this.value = atts.getValue("name");
            this.buffer.delete(0, this.buffer.length());
        } else if (qName.equals(ELEMENT_LIST) && this.mode == this.CONFIGURATION_MODE) {
            System.out.println("new List");
            this.list = new ArrayList();
        } else if (qName.equals(ELEMENT_ENTRY) && this.mode == this.CONFIGURATION_MODE) {
            System.out.println("new Entry");
            this.buffer.delete(0, this.buffer.length());
        }
    }

    private void processConfigurationAttributes(WizardConfiguration config, Attributes atts) {
        int count = atts.getLength();
        int i = 0;
        while (i < count) {
            config.setValue(atts.getQName(i), atts.getValue(i));
            ++i;
        }
    }

    public WizardManager getWizardManager() {
        return this.wizard;
    }

    public static WizardManager createFromFile(String url) {
        WizardFactory factory = new WizardFactory();
        try {
            XMLReader saxparser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            saxparser.setContentHandler(factory);
            saxparser.parse(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return factory.getWizardManager();
    }

    public static WizardManager createDefaultInstaller() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.miethxml.toolkit.wizard.WizardFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String file = clazz.getClassLoader().getResource(DEFAULT_CONFIGFILE).toExternalForm();
        return WizardFactory.createFromFile(file);
    }
}

