/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.Polygon;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Node {
    private List<Polygon> polygons = new ArrayList<Polygon>();
    private Plane plane;
    private Node front;
    private Node back;

    public Node(List<Polygon> polygons) {
        if (polygons != null) {
            this.build(polygons);
        }
    }

    public Node() {
        this(null);
    }

    public Node clone() {
        Node node = new Node();
        node.plane = this.plane == null ? null : this.plane.clone();
        node.front = this.front == null ? null : this.front.clone();
        node.back = this.back == null ? null : this.back.clone();
        Stream polygonStream = this.polygons.size() > 200 ? this.polygons.parallelStream() : this.polygons.stream();
        node.polygons = polygonStream.map(p -> p.clone()).collect(Collectors.toList());
        return node;
    }

    public void invert() {
        Stream polygonStream = this.polygons.size() > 200 ? this.polygons.parallelStream() : this.polygons.stream();
        polygonStream.forEach(polygon -> polygon.flip());
        if (this.plane == null && !this.polygons.isEmpty()) {
            this.plane = this.polygons.get((int)0).plane.clone();
        } else if (this.plane == null && this.polygons.isEmpty()) {
            throw new RuntimeException("Please fix me! I don't know what to do?");
        }
        this.plane.flip();
        if (this.front != null) {
            this.front.invert();
        }
        if (this.back != null) {
            this.back.invert();
        }
        Node temp = this.front;
        this.front = this.back;
        this.back = temp;
    }

    private List<Polygon> clipPolygons(List<Polygon> polygons) {
        if (this.plane == null) {
            return new ArrayList<Polygon>(polygons);
        }
        List<Polygon> frontP = new ArrayList<Polygon>();
        List<Polygon> backP = new ArrayList<Polygon>();
        for (Polygon polygon : polygons) {
            this.plane.splitPolygon(polygon, frontP, backP, frontP, backP);
        }
        if (this.front != null) {
            frontP = this.front.clipPolygons(frontP);
        }
        backP = this.back != null ? this.back.clipPolygons(backP) : new ArrayList(0);
        frontP.addAll(backP);
        return frontP;
    }

    public void clipTo(Node bsp) {
        this.polygons = bsp.clipPolygons(this.polygons);
        if (this.front != null) {
            this.front.clipTo(bsp);
        }
        if (this.back != null) {
            this.back.clipTo(bsp);
        }
    }

    public List<Polygon> allPolygons() {
        ArrayList<Polygon> localPolygons = new ArrayList<Polygon>(this.polygons);
        if (this.front != null) {
            localPolygons.addAll(this.front.allPolygons());
        }
        if (this.back != null) {
            localPolygons.addAll(this.back.allPolygons());
        }
        return localPolygons;
    }

    public final void build(List<Polygon> polygons) {
        if (polygons.isEmpty()) {
            return;
        }
        if (this.plane == null) {
            this.plane = polygons.get((int)0).plane.clone();
        }
        ArrayList<Polygon> frontP = new ArrayList<Polygon>();
        ArrayList<Polygon> backP = new ArrayList<Polygon>();
        polygons.forEach(polygon -> this.plane.splitPolygon((Polygon)polygon, this.polygons, this.polygons, (List<Polygon>)frontP, (List<Polygon>)backP));
        if (frontP.size() > 0) {
            if (this.front == null) {
                this.front = new Node();
            }
            this.front.build(frontP);
        }
        if (backP.size() > 0) {
            if (this.back == null) {
                this.back = new Node();
            }
            this.back.build(backP);
        }
    }
}

