/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Bounds;
import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Polygon {
    public final List<Vertex> vertices;
    private PropertyStorage shared;
    public final Plane plane;
    private final Exception creationEventStackTrace = new Exception();

    void setStorage(PropertyStorage storage) {
        this.shared = storage;
    }

    public static List<Polygon> fromConcavePoints(Vector3d ... points) {
        Polygon p = Polygon.fromPoints(points);
        return PolygonUtil.concaveToConvex(p);
    }

    public static List<Polygon> fromConcavePoints(List<Vector3d> points) {
        Polygon p = Polygon.fromPoints(points);
        return PolygonUtil.concaveToConvex(p);
    }

    public Polygon(List<Vertex> vertices, PropertyStorage shared) {
        this.vertices = vertices;
        this.shared = shared;
        this.plane = Plane.createFromPoints(vertices.get((int)0).pos, vertices.get((int)1).pos, vertices.get((int)2).pos);
    }

    public Polygon(List<Vertex> vertices) {
        this.vertices = vertices;
        this.plane = Plane.createFromPoints(vertices.get((int)0).pos, vertices.get((int)1).pos, vertices.get((int)2).pos);
    }

    public Polygon(Vertex ... vertices) {
        this(Arrays.asList(vertices));
    }

    public Polygon clone() {
        ArrayList<Vertex> newVertices = new ArrayList<Vertex>();
        this.vertices.forEach(vertex -> newVertices.add(vertex.clone()));
        return new Polygon(newVertices, this.getStorage());
    }

    public Polygon flip() {
        this.vertices.forEach(vertex -> vertex.flip());
        Collections.reverse(this.vertices);
        this.plane.flip();
        return this;
    }

    public Polygon flipped() {
        return this.clone().flip();
    }

    public String toStlString() {
        return this.toStlString(new StringBuilder()).toString();
    }

    public StringBuilder toStlString(StringBuilder sb) {
        if (this.vertices.size() >= 3) {
            String firstVertexStl = this.vertices.get(0).toStlString();
            for (int i = 0; i < this.vertices.size() - 2; ++i) {
                sb.append("  facet normal ").append(this.plane.normal.toStlString()).append("\n").append("    outer loop\n").append("      ").append(firstVertexStl).append("\n").append("      ");
                this.vertices.get(i + 1).toStlString(sb).append("\n").append("      ");
                this.vertices.get(i + 2).toStlString(sb).append("\n").append("    endloop\n").append("  endfacet\n");
            }
        }
        return sb;
    }

    public Polygon translate(Vector3d v) {
        this.vertices.forEach(vertex -> {
            vertex.pos = vertex.pos.plus(v);
        });
        Vector3d a = this.vertices.get((int)0).pos;
        Vector3d b = this.vertices.get((int)1).pos;
        Vector3d c = this.vertices.get((int)2).pos;
        this.plane.normal = b.minus(a).cross(c.minus(a));
        return this;
    }

    public Polygon translated(Vector3d v) {
        return this.clone().translate(v);
    }

    public Polygon transform(Transform transform) {
        this.vertices.stream().forEach(v -> v.transform(transform));
        Vector3d a = this.vertices.get((int)0).pos;
        Vector3d b = this.vertices.get((int)1).pos;
        Vector3d c = this.vertices.get((int)2).pos;
        this.plane.normal = b.minus(a).cross(c.minus(a)).normalized();
        this.plane.dist = this.plane.normal.dot(a);
        if (transform.isMirror()) {
            this.flip();
        }
        return this;
    }

    public Polygon transformed(Transform transform) {
        return this.clone().transform(transform);
    }

    public static Polygon fromPoints(List<Vector3d> points, PropertyStorage shared) {
        return Polygon.fromPoints(points, shared, null);
    }

    public static Polygon fromPoints(List<Vector3d> points) {
        return Polygon.fromPoints(points, new PropertyStorage(), null);
    }

    public static Polygon fromPoints(Vector3d ... points) {
        return Polygon.fromPoints(Arrays.asList(points), new PropertyStorage(), null);
    }

    private static Polygon fromPoints(List<Vector3d> points, PropertyStorage shared, Plane plane) {
        Vector3d normal = plane != null ? plane.normal.clone() : new Vector3d(0.0, 0.0, 0.0);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (Vector3d p : points) {
            Vector3d vec = p.clone();
            Vertex vertex = new Vertex(vec, normal);
            vertices.add(vertex);
        }
        return new Polygon(vertices, shared);
    }

    public Bounds getBounds() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex vert = this.vertices.get(i);
            if (vert.pos.x < minX) {
                minX = vert.pos.x;
            }
            if (vert.pos.y < minY) {
                minY = vert.pos.y;
            }
            if (vert.pos.z < minZ) {
                minZ = vert.pos.z;
            }
            if (vert.pos.x > maxX) {
                maxX = vert.pos.x;
            }
            if (vert.pos.y > maxY) {
                maxY = vert.pos.y;
            }
            if (!(vert.pos.z > maxZ)) continue;
            maxZ = vert.pos.z;
        }
        return new Bounds(new Vector3d(minX, minY, minZ), new Vector3d(maxX, maxY, maxZ));
    }

    public boolean contains(Vector3d p) {
        double px = p.x;
        double py = p.y;
        boolean oddNodes = false;
        double x2 = this.vertices.get((int)(this.vertices.size() - 1)).pos.x;
        double y2 = this.vertices.get((int)(this.vertices.size() - 1)).pos.y;
        for (int i = 0; i < this.vertices.size(); ++i) {
            double x1 = this.vertices.get((int)i).pos.x;
            double y1 = this.vertices.get((int)i).pos.y;
            if ((y1 < py && y2 >= py || y1 >= py && y2 < py) && (py - y1) / (y2 - y1) * (x2 - x1) < px - x1) {
                oddNodes = !oddNodes;
            }
            x2 = x1;
            y2 = y1;
        }
        return oddNodes;
    }

    public boolean contains(Polygon p) {
        for (Vertex v : p.vertices) {
            if (this.contains(v.pos)) continue;
            return false;
        }
        return true;
    }

    public PropertyStorage getStorage() {
        if (this.shared == null) {
            this.shared = new PropertyStorage();
        }
        return this.shared;
    }

    public Exception getCreationEventStackTrace() {
        return this.creationEventStackTrace;
    }
}

