/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.parametrics.LengthParameter;
import java.util.ArrayList;
import java.util.List;

public class Sphere
extends Primitive {
    private Vector3d center;
    private double radius;
    private int numSlices;
    private int numStacks;
    private final PropertyStorage properties = new PropertyStorage();

    public Sphere() {
        this.init();
    }

    public Sphere(double radius) {
        this.init();
        this.radius = radius;
    }

    public Sphere(LengthParameter size) {
        this(size.getMM());
        this.parametrics.add(size);
    }

    public Sphere(LengthParameter size, int numSlices, int numStacks) {
        this(size.getMM(), numSlices, numStacks);
        this.parametrics.add(size);
    }

    public Sphere(double radius, int numSlices, int numStacks) {
        this.init();
        this.radius = radius;
        this.numSlices = numSlices;
        this.numStacks = numStacks;
    }

    public Sphere(Vector3d center, double radius, int numSlices, int numStacks) {
        this.center = center;
        this.radius = radius;
        this.numSlices = numSlices;
        this.numStacks = numStacks;
    }

    private void init() {
        this.center = new Vector3d(0.0, 0.0, 0.0);
        this.radius = 1.0;
        this.numSlices = 16;
        this.numStacks = 8;
    }

    private Vertex sphereVertex(Vector3d c, double r, double theta, double phi) {
        Vector3d dir = new Vector3d(Math.cos(theta *= Math.PI * 2) * Math.sin(phi *= Math.PI), Math.cos(phi), Math.sin(theta) * Math.sin(phi));
        return new Vertex(c.plus(dir.times(r)), dir);
    }

    @Override
    public List<Polygon> toPolygons() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.numSlices; ++i) {
            for (int j = 0; j < this.numStacks; ++j) {
                ArrayList<Vertex> vertices = new ArrayList<Vertex>();
                vertices.add(this.sphereVertex(this.center, this.radius, (double)i / (double)this.numSlices, (double)j / (double)this.numStacks));
                if (j > 0) {
                    vertices.add(this.sphereVertex(this.center, this.radius, (double)(i + 1) / (double)this.numSlices, (double)j / (double)this.numStacks));
                }
                if (j < this.numStacks - 1) {
                    vertices.add(this.sphereVertex(this.center, this.radius, (double)(i + 1) / (double)this.numSlices, (double)(j + 1) / (double)this.numStacks));
                }
                vertices.add(this.sphereVertex(this.center, this.radius, (double)i / (double)this.numSlices, (double)(j + 1) / (double)this.numStacks));
                polygons.add(new Polygon(vertices, this.getProperties()));
            }
        }
        return polygons;
    }

    public Vector3d getCenter() {
        return this.center;
    }

    public void setCenter(Vector3d center) {
        this.center = center;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    public void setNumSlices(int numSlices) {
        this.numSlices = numSlices;
    }

    public int getNumStacks() {
        return this.numStacks;
    }

    public void setNumStacks(int numStacks) {
        this.numStacks = numStacks;
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }
}

