/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FractalStructure {
    int numberOfGroundEdges = 3;
    double thickness = 1.0;
    double NextThicknessDivider = 6.0;
    double NextThickness = this.thickness / this.NextThicknessDivider;
    static ArrayList<Double> thicknessList = null;
    int crossConnectionsRate = 25;
    int maxAngleForCrossConections = 45;
    Vector3d groundCenter = null;
    Vector3d topCenter = null;
    List<Vector3d> groundPoints = null;
    List<Vector3d> topPoints = null;
    List<CSG> subStructures = null;
    int level = 0;
    Vector3d orthoVecToRotAxis1 = null;
    Vector3d orthoVecToRotAxis2 = null;
    double orthoThreshhold = 1.0E-16;

    public FractalStructure(Vector3d groundCenter, Vector3d topCenter, int numberOfGroundEdges, double thickness, int level, Vector3d orthoVecToRotAxis1, Vector3d orthoVecToRotAxis2) {
        this.NextThickness = thickness / this.NextThicknessDivider;
        if (numberOfGroundEdges < 3) {
            numberOfGroundEdges = 3;
            System.err.println("numberOfGroundEdges need to be at least 3 and is set therefore to 3.");
        }
        this.numberOfGroundEdges = numberOfGroundEdges;
        this.level = level;
        this.groundCenter = groundCenter;
        this.topCenter = topCenter;
        this.groundPoints = new ArrayList<Vector3d>();
        this.topPoints = new ArrayList<Vector3d>();
        Vector3d rotationAxis = new Vector3d(topCenter.x - groundCenter.x, topCenter.y - groundCenter.y, topCenter.z - groundCenter.z).normalized();
        this.orthoVecToRotAxis1 = orthoVecToRotAxis1 != null ? (Math.abs(orthoVecToRotAxis1.dot(rotationAxis)) < this.orthoThreshhold ? orthoVecToRotAxis1.normalized() : rotationAxis.orthogonal().normalized()) : rotationAxis.orthogonal().normalized();
        this.orthoVecToRotAxis2 = orthoVecToRotAxis2 != null ? (Math.abs(orthoVecToRotAxis2.dot(this.orthoVecToRotAxis1)) < this.orthoThreshhold && Math.abs(orthoVecToRotAxis2.dot(rotationAxis)) < this.orthoThreshhold ? orthoVecToRotAxis2.normalized() : rotationAxis.cross(this.orthoVecToRotAxis1).normalized()) : rotationAxis.cross(this.orthoVecToRotAxis1).normalized();
        Vector3d circlePoint = null;
        double angleStepSize = 360.0 / (double)numberOfGroundEdges;
        double angle = 0.0;
        double radians = 0.0;
        double radius = thickness / 2.0;
        try {
            radius = thicknessList.get(level);
        }
        catch (Exception e) {
            System.out.println("no entry found in thicknessList for level = " + level + ", therefore rule used: radius = thickness / 2.0");
        }
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < numberOfGroundEdges; ++i) {
            angle = (double)i * angleStepSize;
            radians = Math.toRadians(angle);
            x = radius * Math.cos(radians);
            y = radius * Math.sin(radians);
            circlePoint = groundCenter.plus(this.orthoVecToRotAxis1.times(x)).plus(this.orthoVecToRotAxis2.times(y));
            this.groundPoints.add(circlePoint);
            circlePoint = topCenter.plus(this.orthoVecToRotAxis1.times(x)).plus(this.orthoVecToRotAxis2.times(y));
            this.topPoints.add(circlePoint);
        }
        this.groundPoints.add(groundCenter);
        this.topPoints.add(topCenter);
        this.subStructures = new ArrayList<CSG>();
        if (level == 0) {
            this.subStructures.add(this.createStructure());
        } else {
            ArrayList<FractalStructure> subFractals = this.createSubStructures();
            for (int i = 0; i < subFractals.size(); ++i) {
                this.subStructures.add(subFractals.get(i).toCSG());
            }
        }
    }

    private CSG createStructure() {
        int i;
        ArrayList<Polygon> polygonList = new ArrayList<Polygon>();
        ArrayList<Vector3d> tmpList = new ArrayList<Vector3d>();
        for (int i2 = 0; i2 < this.groundPoints.size() - 1; ++i2) {
            tmpList.add(this.groundPoints.get(i2));
        }
        polygonList.add(Polygon.fromPoints(tmpList).flip());
        Vector3d groundP1 = null;
        Vector3d groundP2 = null;
        Vector3d topP1 = null;
        Vector3d topP2 = null;
        for (i = 0; i < tmpList.size() - 1; ++i) {
            groundP1 = this.groundPoints.get(i);
            groundP2 = this.groundPoints.get(i + 1);
            topP1 = this.topPoints.get(i);
            topP2 = this.topPoints.get(i + 1);
            polygonList.add(Polygon.fromPoints(groundP1, groundP2, topP2, topP1));
        }
        groundP1 = this.groundPoints.get(tmpList.size() - 1);
        groundP2 = this.groundPoints.get(0);
        topP1 = this.topPoints.get(tmpList.size() - 1);
        topP2 = this.topPoints.get(0);
        polygonList.add(Polygon.fromPoints(groundP1, groundP2, topP2, topP1));
        tmpList = new ArrayList();
        for (i = 0; i < this.topPoints.size() - 1; ++i) {
            tmpList.add(this.topPoints.get(i));
        }
        polygonList.add(Polygon.fromPoints(tmpList));
        return CSG.fromPolygons(polygonList);
    }

    private ArrayList<FractalStructure> createSubStructures() {
        Vector3d subGroundCenter = null;
        Vector3d subTopCenter = null;
        ArrayList<FractalStructure> subFractalStructures = new ArrayList<FractalStructure>();
        Vector3d tmpGroundPoint = null;
        Vector3d tmpTopPoint = null;
        double correction = -1.0 * this.NextThickness / 2.0;
        for (int i = 0; i < this.numberOfGroundEdges; ++i) {
            tmpGroundPoint = this.groundPoints.get(i);
            subGroundCenter = tmpGroundPoint.minus(this.groundCenter.minus(tmpGroundPoint).times(correction));
            tmpTopPoint = this.topPoints.get(i);
            subTopCenter = tmpTopPoint.minus(this.topCenter.minus(tmpTopPoint).times(correction));
            subFractalStructures.add(new FractalStructure(subGroundCenter, subTopCenter, this.numberOfGroundEdges, this.NextThickness, this.level - 1, this.orthoVecToRotAxis1, this.orthoVecToRotAxis2));
        }
        subFractalStructures.add(new FractalStructure(this.groundCenter, this.topCenter, this.numberOfGroundEdges, this.NextThickness, this.level - 1, this.orthoVecToRotAxis1, this.orthoVecToRotAxis2));
        ArrayList<FractalStructure> crossSubFractalStructures = new ArrayList<FractalStructure>();
        FractalStructure centerStructure = (FractalStructure)subFractalStructures.get(subFractalStructures.size() - 1);
        FractalStructure tmpStructure = null;
        Vector3d centerGroundPoint = centerStructure.groundCenter;
        Vector3d centerTopPoint = centerStructure.topCenter;
        tmpGroundPoint = null;
        tmpTopPoint = null;
        Vector3d helpEdgePoint = null;
        Vector3d helpCenterPoint = null;
        Vector3d connectionLineVector = centerTopPoint.minus(centerGroundPoint);
        Vector3d connectionLineVectorNormalized = connectionLineVector.normalized();
        double stepSizeOnConnectionLine = 10.0 / (double)this.crossConnectionsRate * connectionLineVector.magnitude();
        double stepSizeOnConnectionLineHalf = stepSizeOnConnectionLine / 2.0;
        for (int i = 0; i < subFractalStructures.size() - 1; ++i) {
            tmpStructure = (FractalStructure)subFractalStructures.get(i);
            tmpGroundPoint = tmpStructure.groundCenter;
            helpCenterPoint = connectionLineVectorNormalized.times(stepSizeOnConnectionLineHalf).plus(centerGroundPoint);
            double ankathete = centerGroundPoint.minus(tmpGroundPoint).magnitude();
            double hypothenuse = helpCenterPoint.minus(tmpGroundPoint).magnitude();
            double angle = Math.toDegrees(Math.acos(ankathete / hypothenuse));
            while (angle >= (double)this.maxAngleForCrossConections) {
                stepSizeOnConnectionLine = stepSizeOnConnectionLineHalf;
                helpCenterPoint = connectionLineVectorNormalized.times(stepSizeOnConnectionLineHalf /= 2.0).plus(centerGroundPoint);
                hypothenuse = helpCenterPoint.minus(tmpGroundPoint).magnitude();
                angle = Math.toDegrees(Math.acos(ankathete / hypothenuse));
            }
            Vector3d correctionInRotationAxisDirection = connectionLineVectorNormalized.times(stepSizeOnConnectionLineHalf / 2.0);
            Vector3d secondOrthoVec = null;
            for (double j = 0.0; j < connectionLineVector.magnitude(); j += stepSizeOnConnectionLine) {
                helpEdgePoint = connectionLineVectorNormalized.times(j).plus(tmpGroundPoint).plus(correctionInRotationAxisDirection);
                helpCenterPoint = connectionLineVectorNormalized.times(j).plus(connectionLineVectorNormalized.times(stepSizeOnConnectionLineHalf)).plus(centerGroundPoint).plus(correctionInRotationAxisDirection);
                if (secondOrthoVec == null) {
                    secondOrthoVec = connectionLineVectorNormalized.cross(helpCenterPoint.minus(helpEdgePoint));
                }
                if (connectionLineVector.magnitude() > helpCenterPoint.minus(centerGroundPoint).magnitude()) {
                    crossSubFractalStructures.add(new FractalStructure(helpEdgePoint, helpCenterPoint, this.numberOfGroundEdges, this.NextThickness, this.level - 1, connectionLineVectorNormalized, secondOrthoVec));
                }
                helpEdgePoint = connectionLineVectorNormalized.times(j + stepSizeOnConnectionLine).plus(tmpGroundPoint).plus(correctionInRotationAxisDirection);
                if (!(connectionLineVector.magnitude() > helpEdgePoint.minus(tmpGroundPoint).magnitude())) continue;
                crossSubFractalStructures.add(new FractalStructure(helpEdgePoint, helpCenterPoint, this.numberOfGroundEdges, this.NextThickness, this.level - 1, connectionLineVectorNormalized, secondOrthoVec));
            }
        }
        subFractalStructures.addAll(crossSubFractalStructures);
        return subFractalStructures;
    }

    public CSG toCSG() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        this.subStructures.stream().forEach(csg -> polygons.addAll(csg.getPolygons()));
        return CSG.fromPolygons(polygons);
    }

    public static void main(String[] args) throws IOException {
        CSG csg = new FractalStructure(Vector3d.ZERO, Vector3d.Z_ONE.times(1.0), 4, 15.0, 2, Vector3d.X_ONE, Vector3d.Y_ONE).toCSG();
        FileUtil.write(Paths.get("fractal-structure.stl", new String[0]), csg.toStlString());
        csg.toObj().toFiles(Paths.get("fractal-structure.obj", new String[0]));
    }

    static {
        thicknessList = new ArrayList();
        thicknessList.add(0.01);
        thicknessList.add(0.1);
        thicknessList.add(4.0);
        thicknessList.add(80.0);
        thicknessList.add(160.0);
    }
}

