/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlaneWithHoles {
    public CSG toCSG() {
        CSG result = new Cube(Vector3d.ZERO, new Vector3d(30.0, 30.0, 1.0)).toCSG();
        CSG spheres = null;
        for (int y = 0; y < 11; ++y) {
            System.out.println("line: " + y);
            for (int x = 0; x < 11; ++x) {
                double radius = 1.2;
                double spacing = 0.25;
                CSG sphere = new Sphere(radius).toCSG().transformed(Transform.unity().translate((double)(x - 5) * (radius * 2.0 + spacing), (double)(y - 5) * (radius * 2.0 + spacing), -0.0)).optimization(CSG.OptType.POLYGON_BOUND);
                spheres = spheres == null ? sphere : spheres.union(sphere);
            }
        }
        try {
            FileUtil.write(Paths.get("cyl.stl", new String[0]), spheres.toStlString());
        }
        catch (IOException ex) {
            Logger.getLogger(PlaneWithHoles.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println(">> final diff");
        result = result.difference(spheres);
        return result;
    }

    public static void main(String[] args) throws IOException {
        CSG.setDefaultOptType(CSG.OptType.CSG_BOUND);
        PlaneWithHoles planeWithHoles = new PlaneWithHoles();
        FileUtil.write(Paths.get("sample.stl", new String[0]), planeWithHoles.toCSG().toStlString());
    }
}

