/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;

public class QuadrocopterBottom {
    public static void main(String[] args) throws IOException {
        CSG.setDefaultOptType(CSG.OptType.POLYGON_BOUND);
        CSG result = new QuadrocopterBottom().toCSG();
        FileUtil.write(Paths.get("quadrocopter-bottom.stl", new String[0]), result.toStlString());
        result.toObj().toFiles(Paths.get("quadrocopter-bottom.obj", new String[0]));
    }

    public void print3d(CSG csg, int n) {
        try {
            FileUtil.write(Paths.get("quadrocopter-bottom-" + n + ".stl", new String[0]), csg.toStlString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CSG toCSG() {
        double outerRadius = 93.0;
        double bottomThickness = 3.0;
        int numHoneyCombs = 21;
        double honeyCombWallThickness = 2.0;
        double platformBorderThickness = 5.0;
        CSG base = this.basePlatform(outerRadius, numHoneyCombs, bottomThickness, platformBorderThickness, honeyCombWallThickness);
        return base;
    }

    private CSG basePlatform(double platformRadius, int numHoneycombs, double platformThickness, double platformBorderThickness, double honeycombWallThickness) {
        double honeycombRadius = platformRadius / (double)numHoneycombs;
        CSG platform = new Cylinder(platformRadius, platformThickness, 64).toCSG();
        CSG innerPlatform = new Cylinder(platformRadius - platformBorderThickness, platformThickness, 64).toCSG();
        CSG platformShell = platform.difference(innerPlatform);
        CSG honeycombPrototype = new Cylinder(honeycombRadius, platformThickness, 6).toCSG();
        int numHoneycomb = (int)(platformRadius * 2.0 / (honeycombRadius * 2.0));
        CSG hexagons = null;
        double inradiusOfHexagon = honeycombRadius * Math.cos(0.5235987755982988);
        double sideLength = honeycombRadius * 2.0 * Math.sin(0.5235987755982988);
        numHoneycomb = (int)((double)numHoneycomb * 1.4);
        double centerOffset = 0.0;
        for (int y = 0; y < numHoneycomb; ++y) {
            for (int x = 0; x < numHoneycomb; ++x) {
                double offset = inradiusOfHexagon * (double)(x % 2);
                double dx = -platformRadius + (double)x * sideLength * 1.5;
                double dy = -platformRadius + (double)y * inradiusOfHexagon * 2.0 + offset - honeycombWallThickness / 4.0;
                CSG h = honeycombPrototype.transformed(Transform.unity().translate(dx += honeycombWallThickness * (double)x + centerOffset - honeycombWallThickness / 6.0, dy += honeycombWallThickness * (double)y + honeycombWallThickness * (double)(x % 2) / 2.0 + centerOffset * 1.75 - inradiusOfHexagon * 0.5 + honeycombWallThickness / 2.0, 0.0));
                hexagons = hexagons == null ? h : hexagons.union(h);
            }
        }
        double centerHoleRadius = 15.0;
        double holeBorderThickness = platformBorderThickness;
        double cylHeight = platformThickness;
        CSG centerHoleOuter = new Cylinder(centerHoleRadius + holeBorderThickness, cylHeight, 16).toCSG();
        CSG centerHoleInner = new Cylinder(centerHoleRadius, cylHeight, 16).toCSG();
        CSG centerHoleShell = centerHoleOuter.difference(centerHoleInner);
        if (hexagons != null) {
            platform = platform.difference(hexagons);
        }
        return platform.union(platformShell, centerHoleShell).difference(centerHoleInner);
    }
}

