/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.UnityModifier;
import eu.mihosoft.vrl.v3d.ZModifier;
import java.io.IOException;
import java.nio.file.Paths;

public class Sabine {
    public CSG toCSG() {
        double w = 16.0;
        double h = 9.0;
        double offset = 1.5;
        double fractW = 2.0;
        double fractL = 10.0;
        double fractD = 0.25;
        CSG cube = new Cube(w, h, 1.0).toCSG();
        CSG beam = new Cylinder(1.0, 10.0, 32).toCSG();
        CSG beam1 = beam.weighted(new ZModifier()).transformed(Transform.unity().scale(0.5, 0.5, 1.0)).weighted(new UnityModifier()).transformed(Transform.unity().translate(w / 2.0 - offset, h / 2.0 - offset, 0.0));
        CSG beam2 = beam.transformed(Transform.unity().translate(-(w / 2.0 - offset), h / 2.0 - offset, 0.0));
        CSG beam3 = beam.transformed(Transform.unity().translate(-(w / 2.0 - offset), -(h / 2.0 - offset), 0.0));
        CSG beam4 = beam.transformed(Transform.unity().translate(w / 2.0 - offset, -(h / 2.0 - offset), 0.0));
        CSG fractures = null;
        for (int i = 0; i < 50; ++i) {
            double angleX = 45.0 + Math.random() * 90.0;
            double angleZ = 45.0 + Math.random() * 90.0;
            CSG fracture1 = new Cube(0.1 + fractW * Math.random(), fractL * Math.random(), fractD).noCenter().toCSG().transformed(Transform.unity().rotZ(-angleZ).rotX(-angleX));
            double x = -w / 2.0 + Math.random() * (w - 2.0);
            double y = -h / 2.0 + Math.random() * (h - 2.0);
            fracture1 = fracture1.transformed(Transform.unity().translate(x, y, 0.0));
            fractures = fractures == null ? fracture1 : fractures.union(fracture1);
        }
        CSG diffCube = new Cube(w, h, 11.0).noCenter().toCSG().transformed(Transform.unity().translate(-w / 2.0, -h / 2.0, 0.0));
        fractures = fractures.intersect(diffCube);
        return cube.union(beam1, beam2, beam3, beam4, fractures);
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("sabine.stl", new String[0]), new Sabine().toCSG().toStlString());
    }
}

