/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ServoMountPixy {
    private double servoWidth = 40.5;
    private double servoThickness = 19.0;
    private double borderThickness = 3.0;
    private double overlap = 3.0;
    private double servoMountHeight = 20.0;
    private double boardMountingThickness = 3.0;
    private double boardHolder1Length = 12.0;
    private double boardHolder2Length = 16.0;
    private double boardMountingWidth = 8.1;
    private double pegHeight = 1.0;
    private double pegToothHeight = 0.6;
    private double pegOverlap = 0.5;

    public CSG toCSGSimple() {
        return Extrude.points(new Vector3d(0.0, 0.0, this.servoMountHeight), new Vector3d(0.0, this.servoThickness), new Vector3d(this.overlap, this.servoThickness), new Vector3d(-this.borderThickness, this.servoThickness + this.borderThickness), new Vector3d(-this.borderThickness, -this.borderThickness), new Vector3d(this.servoWidth + this.borderThickness, -this.borderThickness), new Vector3d(this.servoWidth + this.borderThickness, this.servoThickness + this.borderThickness), new Vector3d(this.servoWidth - this.overlap, this.servoThickness), new Vector3d(this.servoWidth, this.servoThickness), new Vector3d(this.servoWidth, 0.0), new Vector3d(0.0, 0.0));
    }

    public CSG toCSG() {
        Transform bm1Transform = Transform.unity().rotY(90.0).rotZ(90.0).translate(this.borderThickness, this.borderThickness, -this.boardHolder1Length + this.borderThickness);
        CSG bm1 = this.boardMount1().transformed(bm1Transform);
        Transform bm2Transform = Transform.unity().translateX(this.servoWidth - this.boardHolder1Length + this.borderThickness * 2.0);
        CSG bm2 = this.boardMountWithPixy().transformed(bm1Transform).transformed(bm2Transform);
        CSG sm = this.toCSGSimple();
        return sm.union(bm1).union(bm2);
    }

    private CSG boardMount1() {
        return this.boardMount(this.boardHolder1Length);
    }

    private CSG boardMount2() {
        return this.boardMount(this.boardHolder2Length);
    }

    private CSG boardMountWithPixy() {
        return this.boardMount2().union(this.pixyMount());
    }

    private CSG pixyMount() {
        double pixyBoardThickness = 2.0;
        double camHeight = 60.0;
        double camHolderHeight = 20.0;
        CSG pixyBoard = new Cube(50.0, 50.0, pixyBoardThickness).toCSG();
        pixyBoard = pixyBoard.transformed(Transform.unity().translate(camHeight + camHolderHeight + this.boardMountingThickness + this.borderThickness * 4.0, pixyBoard.getBounds().getBounds().y * 0.5, this.boardHolder2Length * 0.5));
        return this.pixyMountBase().difference(pixyBoard);
    }

    private CSG pixyMountBase() {
        double h = this.boardMountingWidth;
        double camHeight = 60.0;
        double camHolderHeight = 20.0;
        double camWidth = 53.0;
        double outerPiMountWidth = 60.0;
        double camOverlap = 10.0;
        double upperCamOverlap = 3.0;
        double camHolderWidth = 10.0;
        double breadBoardHeight = 26.0;
        double breadBoardThickness = 9.0;
        double breadBoardOverlap = 14.5;
        double bottomThickness = 3.0;
        List<Vector3d> points = Arrays.asList(new Vector3d(this.boardMountingThickness + this.borderThickness, -this.borderThickness), new Vector3d(this.boardMountingThickness + this.borderThickness + camHeight + camHolderHeight, -this.borderThickness), new Vector3d(this.boardMountingThickness + this.borderThickness + camHeight + camHolderHeight, 0.0 + upperCamOverlap), new Vector3d(this.boardMountingThickness + this.borderThickness + camHeight, outerPiMountWidth - camWidth + camOverlap), new Vector3d(this.boardMountingThickness + this.borderThickness + camHeight - this.borderThickness, outerPiMountWidth - camWidth + camOverlap), new Vector3d(this.boardMountingThickness + this.borderThickness + camHeight - this.borderThickness - camHolderWidth, 0.0), new Vector3d(this.boardMountingThickness + this.borderThickness + breadBoardHeight + breadBoardThickness + this.borderThickness + bottomThickness, 0.0), new Vector3d(this.boardMountingThickness + this.borderThickness + breadBoardHeight + breadBoardThickness + this.borderThickness, breadBoardOverlap), new Vector3d(this.boardMountingThickness + this.borderThickness + breadBoardHeight + breadBoardThickness, breadBoardOverlap), new Vector3d(this.boardMountingThickness + this.borderThickness + breadBoardHeight + breadBoardThickness, 0.0), new Vector3d(this.boardMountingThickness + this.borderThickness + breadBoardHeight, 0.0), new Vector3d(this.boardMountingThickness + this.borderThickness + breadBoardHeight, breadBoardOverlap), new Vector3d(this.boardMountingThickness + this.borderThickness + breadBoardHeight - this.borderThickness, breadBoardOverlap), new Vector3d(this.boardMountingThickness + this.borderThickness + breadBoardHeight - this.borderThickness - bottomThickness, 0.0), new Vector3d(this.boardMountingThickness - this.pegOverlap + this.borderThickness, 0.0), new Vector3d(this.boardMountingThickness, h), new Vector3d(this.boardMountingThickness, 0.0));
        Collections.reverse(points);
        return Extrude.points(new Vector3d(0.0, 0.0, this.boardHolder2Length), points);
    }

    private CSG boardMount(double boardHolderLength) {
        double bottomThickness = 3.0;
        double h = this.boardMountingWidth;
        List<Vector3d> points = Arrays.asList(Vector3d.ZERO, new Vector3d(0.0, -this.borderThickness), new Vector3d(this.boardMountingThickness + this.borderThickness + bottomThickness, -this.borderThickness), new Vector3d(this.boardMountingThickness + this.borderThickness, h + this.pegToothHeight + this.pegHeight), new Vector3d(this.boardMountingThickness - this.pegOverlap, h + this.pegToothHeight + this.pegHeight * 0.25), new Vector3d(this.boardMountingThickness - this.pegOverlap, h + this.pegToothHeight), new Vector3d(this.boardMountingThickness, h), new Vector3d(this.boardMountingThickness, 0.0));
        Collections.reverse(points);
        return Extrude.points(new Vector3d(0.0, 0.0, boardHolderLength), points);
    }

    public static void main(String[] args) throws IOException {
        ServoMountPixy sMount = new ServoMountPixy();
        FileUtil.write(Paths.get("servo-mount-pixy.stl", new String[0]), sMount.toCSG().toStlString());
    }
}

