/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;

public class WeightedSphere {
    public CSG toCSG() {
        CSG morphed;
        CSG prototype;
        CSG result = prototype = new Sphere(3.0, 128, 64).toCSG().optimization(CSG.OptType.POLYGON_BOUND);
        result = morphed = prototype.weighted((v, csg) -> {
            double w = (1.0 + Math.sin(v.z * 2.0) * Math.cos(v.z * 2.0)) / 2.0;
            return w;
        }).transformed(Transform.unity().scale(0.1)).transformed(Transform.unity().translateX(1.0).rotZ(90.0));
        return result;
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("rounded-cube-mod.stl", new String[0]), new WeightedSphere().toCSG().toStlString());
        new WeightedSphere().toCSG().toObj().toFiles(Paths.get("rounded-cube-mod.obj", new String[0]));
    }
}

