/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.svg;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Slice;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class SVGExporter {
    private static final double Scale = 3.543335;

    public static void export(CSG currentCsg, File defaultDir) throws IOException {
        Transform slicePlane = new Transform();
        List<Polygon> polygons = Slice.slice(currentCsg, slicePlane, 0.0);
        SVGExporter.export(polygons, defaultDir);
    }

    public static void export(List<Polygon> polygons, File defaultDir) throws IOException {
        String footer = "</svg>";
        String section = "";
        String output = "";
        double[] min = new double[]{0.0, 0.0};
        double[] max = new double[]{0.0, 0.0};
        for (Polygon p : polygons) {
            section = "  <polyline points=\"";
            for (Vertex v : p.vertices) {
                Vector3d position = v.pos;
                double x = position.x * 3.543335;
                double y = position.y * 3.543335;
                section = section + x + "," + y + " ";
                if (x > max[0]) {
                    max[0] = x;
                }
                if (x < min[0]) {
                    min[0] = x;
                }
                if (y > max[1]) {
                    max[1] = y;
                }
                if (!(y < min[1])) continue;
                min[1] = y;
            }
            Vector3d position = p.vertices.get((int)0).pos;
            double x = position.x * 3.543335;
            double y = position.y * 3.543335;
            section = section + x + "," + y + " ";
            output = output + section + "\" stroke=\"red\" stroke-width=\"0.1\" fill=\"none\" />\n";
        }
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"" + (min[0] - 1.0) + " " + (min[1] - 1.0) + " " + (Math.abs(max[0]) + Math.abs(min[0]) + 2.0) + " " + (Math.abs(max[1]) + Math.abs(min[1]) + 2.0) + "\">\n";
        output = output + footer;
        output = header + output;
        if (!defaultDir.exists()) {
            defaultDir.createNewFile();
        }
        FileWriter fw = new FileWriter(defaultDir.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(output);
        bw.close();
    }
}

