/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vvecmath;

import eu.mihosoft.vvecmath.Spline;
import eu.mihosoft.vvecmath.Vector3d;
import java.util.ArrayList;
import java.util.List;

public final class Spline3D
extends Spline {
    private final List<Vector3d> points = new ArrayList<Vector3d>();
    private final List<Spline.Cubic> xCubics = new ArrayList<Spline.Cubic>();
    private final List<Spline.Cubic> yCubics = new ArrayList<Spline.Cubic>();
    private final List<Spline.Cubic> zCubics = new ArrayList<Spline.Cubic>();

    public void addPoint(Vector3d point) {
        this.points.add(point);
    }

    public List<Vector3d> getPoints() {
        return this.points;
    }

    public void calcSpline() {
        this.calcNaturalCubic((List)this.points, 0, this.xCubics);
        this.calcNaturalCubic((List)this.points, 1, this.yCubics);
        this.calcNaturalCubic((List)this.points, 2, this.zCubics);
    }

    public Vector3d getPoint(double position) {
        int cubicNum = (int)(position *= (double)this.xCubics.size());
        double cubicPos = position - (double)cubicNum;
        return Vector3d.xyz(this.xCubics.get(cubicNum).eval(cubicPos), this.yCubics.get(cubicNum).eval(cubicPos), this.zCubics.get(cubicNum).eval(cubicPos));
    }
}

