/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGFontFace;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFontFaceElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public String getLocalName() {
        return "font-face";
    }

    public SVGFontFace createFontFace(BridgeContext bridgeContext, Element element) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        String string;
        float f9;
        String string2;
        String string3;
        String string4;
        String string5;
        float f10;
        String string6 = element.getAttributeNS(null, "font-family");
        String string7 = element.getAttributeNS(null, "units-per-em");
        if (string7.length() == 0) {
            string7 = "1000";
        }
        try {
            f10 = SVGUtilities.convertSVGNumber(string7);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"units-per-em", string7});
        }
        String string8 = element.getAttributeNS(null, "font-weight");
        if (string8.length() == 0) {
            string8 = "all";
        }
        if ((string5 = element.getAttributeNS(null, "font-style")).length() == 0) {
            string5 = "all";
        }
        if ((string4 = element.getAttributeNS(null, "font-variant")).length() == 0) {
            string4 = "normal";
        }
        if ((string3 = element.getAttributeNS(null, "font-stretch")).length() == 0) {
            string3 = "normal";
        }
        if ((string2 = element.getAttributeNS(null, "slope")).length() == 0) {
            string2 = "0";
        }
        try {
            f9 = SVGUtilities.convertSVGNumber(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string2});
        }
        String string9 = element.getAttributeNS(null, "panose-1");
        if (string9.length() == 0) {
            string9 = "0 0 0 0 0 0 0 0 0 0";
        }
        if ((string = element.getAttributeNS(null, "ascent")).length() == 0) {
            string = String.valueOf((double)f10 * 0.8);
        }
        try {
            f8 = SVGUtilities.convertSVGNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string});
        }
        String string10 = element.getAttributeNS(null, "descent");
        if (string10.length() == 0) {
            string10 = String.valueOf((double)f10 * 0.2);
        }
        try {
            f7 = SVGUtilities.convertSVGNumber(string10);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string10});
        }
        String string11 = element.getAttributeNS(null, "underline-position");
        if (string11.length() == 0) {
            string11 = String.valueOf(-3.0f * f10 / 40.0f);
        }
        try {
            f6 = SVGUtilities.convertSVGNumber(string11);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string11});
        }
        String string12 = element.getAttributeNS(null, "underline-thickness");
        if (string12.length() == 0) {
            string12 = String.valueOf(f10 / 20.0f);
        }
        try {
            f5 = SVGUtilities.convertSVGNumber(string12);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string12});
        }
        String string13 = element.getAttributeNS(null, "strikethrough-position");
        if (string13.length() == 0) {
            string13 = String.valueOf(3.0f * f8 / 8.0f);
        }
        try {
            f4 = SVGUtilities.convertSVGNumber(string13);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string13});
        }
        String string14 = element.getAttributeNS(null, "strikethrough-thickness");
        if (string14.length() == 0) {
            string14 = String.valueOf(f10 / 20.0f);
        }
        try {
            f3 = SVGUtilities.convertSVGNumber(string14);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string14});
        }
        String string15 = element.getAttributeNS(null, "overline-position");
        if (string15.length() == 0) {
            string15 = String.valueOf(f8);
        }
        try {
            f2 = SVGUtilities.convertSVGNumber(string15);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string15});
        }
        String string16 = element.getAttributeNS(null, "overline-thickness");
        if (string16.length() == 0) {
            string16 = String.valueOf(f10 / 20.0f);
        }
        try {
            f = SVGUtilities.convertSVGNumber(string16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"0", string16});
        }
        List list = null;
        Element element2 = SVGUtilities.getParentElement(element);
        if (!element2.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !element2.getLocalName().equals("font")) {
            list = this.getFontFaceSrcs(element);
        }
        return new SVGFontFace(element, list, string6, f10, string8, string5, string4, string3, f9, string9, f8, f7, f4, f3, f6, f5, f2, f);
    }

    public List getFontFaceSrcs(Element element) {
        Object object;
        Node node = null;
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1 || !object.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !object.getLocalName().equals("font-face-src")) continue;
            node = (Element)object;
            break;
        }
        if (node == null) {
            return null;
        }
        object = new LinkedList();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string;
            Element element2;
            if (node2.getNodeType() != 1 || !node2.getNamespaceURI().equals("http://www.w3.org/2000/svg")) continue;
            if (node2.getLocalName().equals("font-face-uri")) {
                element2 = (Element)node2;
                string = XLinkSupport.getXLinkHref(element2);
                String string2 = AbstractNode.getBaseURI(element2);
                ParsedURL parsedURL = string2 != null ? new ParsedURL(string2, string) : new ParsedURL(string);
                object.add(parsedURL);
                continue;
            }
            if (!node2.getLocalName().equals("font-face-name") || (string = (element2 = (Element)node2).getAttribute("name")).length() == 0) continue;
            object.add(string);
        }
        return object;
    }
}

