/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFDimensionStyle;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFHatchPattern;
import org.kabeja.dxf.DXFHeader;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLineType;
import org.kabeja.dxf.DXFStyle;
import org.kabeja.dxf.DXFView;
import org.kabeja.dxf.DXFViewport;
import org.kabeja.dxf.objects.DXFDictionary;
import org.kabeja.dxf.objects.DXFObject;

public class DXFDocument {
    public static String PROPERTY_ENCODING = "encoding";
    public static final double DEFAULT_MARGIN = 5.0;
    private Hashtable layers = new Hashtable();
    private Hashtable blocks = new Hashtable();
    private HashMap lineTypes = new HashMap();
    private HashMap dimensionStyles = new HashMap();
    private HashMap textStyles = new HashMap();
    private Hashtable ucs = new Hashtable();
    private Hashtable properties = new Hashtable();
    private List viewports = new ArrayList();
    private Bounds bounds = new Bounds();
    private double margin;
    private DXFHeader header = new DXFHeader();
    private HashMap objects = new HashMap();
    private HashMap patterns = new HashMap();
    private List views = new ArrayList();
    private DXFDictionary rootDictionary = new DXFDictionary();

    public DXFDocument() {
        DXFLayer dXFLayer = new DXFLayer();
        dXFLayer.setDXFDocument(this);
        dXFLayer.setName("0");
        this.layers.put("0", dXFLayer);
        this.margin = 5.0;
        this.rootDictionary = new DXFDictionary();
        this.rootDictionary.setDXFDocument(this);
    }

    public void addDXFLayer(DXFLayer dXFLayer) {
        dXFLayer.setDXFDocument(this);
        this.layers.put(dXFLayer.getName(), dXFLayer);
    }

    public DXFLayer getDXFLayer(String string) {
        if (this.layers.containsKey(string)) {
            return (DXFLayer)this.layers.get(string);
        }
        if (this.layers.containsKey("0")) {
            return (DXFLayer)this.layers.get("0");
        }
        DXFLayer dXFLayer = new DXFLayer();
        dXFLayer.setName("0");
        this.addDXFLayer(dXFLayer);
        return dXFLayer;
    }

    public boolean containsDXFLayer(String string) {
        return this.layers.containsKey(string);
    }

    public Iterator getDXFLayerIterator() {
        return this.layers.values().iterator();
    }

    public void addDXFLineType(DXFLineType dXFLineType) {
        this.lineTypes.put(dXFLineType.getName(), dXFLineType);
    }

    public DXFLineType getDXFLineType(String string) {
        return (DXFLineType)this.lineTypes.get(string);
    }

    public Iterator getDXFLineTypeIterator() {
        return this.lineTypes.values().iterator();
    }

    public void addDXFEntity(DXFEntity dXFEntity) {
        dXFEntity.setDXFDocument(this);
        DXFLayer dXFLayer = this.getDXFLayer(dXFEntity.getLayerName());
        dXFLayer.addDXFEntity(dXFEntity);
    }

    public void addDXFBlock(DXFBlock dXFBlock) {
        dXFBlock.setDXFDocument(this);
        this.blocks.put(dXFBlock.getName(), dXFBlock);
    }

    public DXFBlock getDXFBlock(String string) {
        return (DXFBlock)this.blocks.get(string);
    }

    public Iterator getDXFBlockIterator() {
        return this.blocks.values().iterator();
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getProperty(String string) {
        if (this.properties.contains(string)) {
            return (String)this.properties.get(string);
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.properties.containsKey(string);
    }

    public Bounds getBounds() {
        this.bounds = new Bounds();
        Enumeration enumeration = this.layers.elements();
        while (enumeration.hasMoreElements()) {
            Bounds bounds;
            DXFLayer dXFLayer = (DXFLayer)enumeration.nextElement();
            if (dXFLayer.isFrozen() || !(bounds = dXFLayer.getBounds()).isValid()) continue;
            this.bounds.addToBounds(bounds);
        }
        return this.bounds;
    }

    public Bounds getBounds(boolean bl) {
        Bounds bounds = new Bounds();
        Enumeration enumeration = this.layers.elements();
        while (enumeration.hasMoreElements()) {
            Bounds bounds2;
            DXFLayer dXFLayer = (DXFLayer)enumeration.nextElement();
            if (dXFLayer.isFrozen() || !(bounds2 = dXFLayer.getBounds(bl)).isValid()) continue;
            bounds.addToBounds(bounds2);
        }
        return bounds;
    }

    public double getHeight() {
        return this.bounds.getHeight();
    }

    public double getWidth() {
        return this.bounds.getWidth();
    }

    public DXFHeader getDXFHeader() {
        return this.header;
    }

    public void setDXFHeader(DXFHeader dXFHeader) {
        this.header = dXFHeader;
    }

    public void addDXFDimensionStyle(DXFDimensionStyle dXFDimensionStyle) {
        this.dimensionStyles.put(dXFDimensionStyle.getName(), dXFDimensionStyle);
    }

    public DXFDimensionStyle getDXFDimensionStyle(String string) {
        return (DXFDimensionStyle)this.dimensionStyles.get(string);
    }

    public Iterator getDXFDimensionStyleIterator() {
        return this.dimensionStyles.values().iterator();
    }

    public void addDXStyle(DXFStyle dXFStyle) {
        this.textStyles.put(dXFStyle.getName(), dXFStyle);
    }

    public DXFStyle getDXFStyle(String string) {
        return (DXFStyle)this.textStyles.get(string);
    }

    public Iterator getDXFStyleIterator() {
        return this.textStyles.values().iterator();
    }

    public void removeDXFLayer(String string) {
        this.layers.remove(string);
    }

    public void addDXFViewport(DXFViewport dXFViewport) {
        this.viewports.add(dXFViewport);
    }

    public Iterator getDXFViewportIterator() {
        return this.viewports.iterator();
    }

    public void removeDXFViewport(DXFViewport dXFViewport) {
        this.viewports.remove(dXFViewport);
    }

    public void removeDXFViewport(int n) {
        this.viewports.remove(n);
    }

    public void addDXFView(DXFView dXFView) {
        this.views.add(dXFView);
    }

    public Iterator getDXFViewIterator() {
        return this.views.iterator();
    }

    public void addDXFObject(DXFObject dXFObject) {
        DXFDictionary dXFDictionary = this.rootDictionary.getDXFDictionaryForID(dXFObject.getID());
        if (dXFDictionary != null) {
            dXFDictionary.putDXFObject(dXFObject);
        } else {
            HashMap hashMap = null;
            if (this.objects.containsKey(dXFObject.getObjectType())) {
                hashMap = (HashMap)this.objects.get(dXFObject.getObjectType());
            } else {
                hashMap = new HashMap();
                this.objects.put(dXFObject.getObjectType(), hashMap);
            }
            hashMap.put(dXFObject.getID(), dXFObject);
        }
    }

    public DXFDictionary getRootDXFDictionary() {
        return this.rootDictionary;
    }

    public void setRootDXFDictionary(DXFDictionary dXFDictionary) {
        this.rootDictionary = dXFDictionary;
    }

    public List getDXFObjectsByType(String string) {
        HashMap hashMap = (HashMap)this.objects.get(string);
        ArrayList arrayList = new ArrayList(hashMap.values());
        return arrayList;
    }

    public DXFObject getDXFObjectByID(String string) {
        Iterator iterator = this.objects.values().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap = (HashMap)iterator.next();
            Object v = hashMap.get(string);
            if (v == null) continue;
            return (DXFObject)v;
        }
        return this.rootDictionary.getDXFObjectByID(string);
    }

    public DXFEntity getDXFEntityByID(String string) {
        Object object;
        DXFEntity dXFEntity = null;
        Iterator iterator = this.getDXFLayerIterator();
        while (iterator.hasNext()) {
            object = (DXFLayer)iterator.next();
            dXFEntity = ((DXFLayer)object).getDXFEntityByID(string);
            if (dXFEntity == null) continue;
            return dXFEntity;
        }
        iterator = this.getDXFBlockIterator();
        while (iterator.hasNext()) {
            object = (DXFBlock)iterator.next();
            dXFEntity = ((DXFBlock)object).getDXFEntityByID(string);
            if (dXFEntity == null) continue;
            return dXFEntity;
        }
        return dXFEntity;
    }

    public void addDXFHatchPattern(DXFHatchPattern dXFHatchPattern) {
        this.patterns.put(dXFHatchPattern.getID(), dXFHatchPattern);
    }

    public Iterator getDXFHatchPatternIterator() {
        return this.patterns.values().iterator();
    }

    public DXFHatchPattern getDXFHatchPattern(String string) {
        return (DXFHatchPattern)this.patterns.get(string);
    }
}

