/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.dxf.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.dxf.filter.DXFStreamEntityFilter;

public class DXFStreamLayerFilter
extends DXFStreamEntityFilter {
    public static final String PROPERTY_LAYERS_EXCLUDE = "layers.exclude";
    public static final String PROPERTY_LAYERS_INCLUDE = "layers.include";
    public static final int LAYER_NAME = 8;
    protected List parseValues = new ArrayList();
    protected Set exclude = new HashSet();
    protected Set include = new HashSet();
    protected String layer = "";
    boolean findLayer = true;

    public void setProperties(Map map) {
        StringTokenizer stringTokenizer;
        if (map.containsKey(PROPERTY_LAYERS_INCLUDE)) {
            this.include.clear();
            stringTokenizer = new StringTokenizer((String)map.get(PROPERTY_LAYERS_INCLUDE), "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                this.include.add(string);
            }
        }
        if (map.containsKey(PROPERTY_LAYERS_EXCLUDE)) {
            this.exclude.clear();
            stringTokenizer = new StringTokenizer((String)map.get(PROPERTY_LAYERS_EXCLUDE), "|");
            while (stringTokenizer.hasMoreTokens()) {
                this.exclude.add(stringTokenizer.nextToken());
            }
        }
    }

    protected void endEntity() throws ParseException {
        if (this.include.contains(this.layer)) {
            this.outputEntity();
        } else if (!this.exclude.contains(this.layer)) {
            this.outputEntity();
        }
    }

    protected void outputEntity() throws ParseException {
        for (int i = 0; i < this.parseValues.size(); ++i) {
            ParseValue parseValue = (ParseValue)this.parseValues.get(i);
            this.handler.parseGroup(parseValue.getGroupCode(), parseValue.getDXFValue());
        }
    }

    protected void startEntity(String string) throws ParseException {
        this.parseValues.clear();
        this.findLayer = true;
    }

    protected void parseEntity(int n, DXFValue dXFValue) throws ParseException {
        if (this.findLayer && n == 8) {
            this.layer = dXFValue.getValue();
            this.findLayer = false;
        }
        ParseValue parseValue = new ParseValue(n, dXFValue);
        this.parseValues.add(parseValue);
    }

    private class ParseValue {
        int groupCode;
        DXFValue value;

        public ParseValue(int n, DXFValue dXFValue) {
            this.groupCode = n;
            this.value = dXFValue;
        }

        public int getGroupCode() {
            return this.groupCode;
        }

        public DXFValue getDXFValue() {
            return this.value;
        }
    }
}

