/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg;

import java.io.File;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import org.kabeja.dxf.DXFLineType;
import org.kabeja.dxf.helpers.StyledTextParagraph;
import org.kabeja.dxf.helpers.TextDocument;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGUtils {
    public static String DEFAUL_ATTRIBUTE_TYPE = "CDATA";
    public static String DEFAULT_ID_NAME_PREFIX = "ID_";
    private static DecimalFormat format;

    public static void startElement(ContentHandler handler, String element, Attributes attr) throws SAXException {
        handler.startElement("http://www.w3.org/2000/svg", element, element, attr);
    }

    public static void endElement(ContentHandler handler, String element) throws SAXException {
        handler.endElement("http://www.w3.org/2000/svg", element, element);
    }

    public static void addAttribute(AttributesImpl attr, String name, String value) {
        attr.addAttribute("", name, name, DEFAUL_ATTRIBUTE_TYPE, value);
    }

    public static void characters(ContentHandler handler, String text) throws SAXException {
        char[] data = text.toCharArray();
        handler.characters(data, 0, data.length);
    }

    public static void emptyElement(ContentHandler handler, String element, Attributes attr) throws SAXException {
        SVGUtils.startElement(handler, element, attr);
        SVGUtils.endElement(handler, element);
    }

    public static void addStrokeDashArrayAttribute(AttributesImpl attr, DXFLineType ltype) {
        SVGUtils.addStrokeDashArrayAttribute(attr, ltype, 1.0);
    }

    public static void addStrokeDashArrayAttribute(AttributesImpl attr, DXFLineType ltype, double scale) {
        double[] pattern;
        if (ltype != null && (pattern = ltype.getPattern()).length > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < pattern.length; ++i) {
                if (pattern[i] != 0.0) {
                    buf.append(format.format(Math.abs(pattern[i] * scale)));
                } else {
                    buf.append("0.05%");
                }
                buf.append(", ");
            }
            buf.deleteCharAt(buf.length() - 2);
            SVGUtils.addAttribute(attr, "stroke-dasharray", buf.toString());
        }
    }

    public static String validateID(String id) {
        if (id.length() > 0) {
            StringBuffer buf = new StringBuffer();
            char first = id.charAt(0);
            if (!Character.isLetter(first) && first != '_' && first != ':') {
                buf.append(DEFAULT_ID_NAME_PREFIX);
            }
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.' || c == ':') {
                    buf.append(c);
                    continue;
                }
                buf.append("_#");
                buf.append((int)c);
                buf.append('_');
            }
            return buf.toString();
        }
        return id;
    }

    public static String reverseID(String id) {
        if (id.length() > 0) {
            StringBuffer buf = new StringBuffer();
            boolean marker = false;
            boolean start = false;
            StringBuffer number = new StringBuffer();
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (c == '_') {
                    if (marker) {
                        if (number.length() > 0) {
                            int x = Integer.parseInt(number.toString());
                            buf.append((char)x);
                            start = false;
                            number.delete(0, number.length());
                        } else {
                            buf.append('_');
                            buf.append(c);
                        }
                        marker = false;
                        continue;
                    }
                    marker = true;
                    continue;
                }
                if (marker) {
                    if (Character.isDigit(c) && start) {
                        number.append(c);
                        continue;
                    }
                    if (c != '#') {
                        marker = false;
                        buf.append('_');
                        buf.append(c);
                        continue;
                    }
                    start = true;
                    continue;
                }
                buf.append(c);
            }
            if (marker) {
                buf.append('_');
            }
            if (buf.toString().startsWith(DEFAULT_ID_NAME_PREFIX)) {
                buf.delete(0, DEFAULT_ID_NAME_PREFIX.length());
            }
            return buf.toString();
        }
        return id;
    }

    public static void textDocumentToSAX(ContentHandler handler, TextDocument doc) throws SAXException {
        Iterator i = doc.getStyledParagraphIterator();
        while (i.hasNext()) {
            StyledTextParagraph para = (StyledTextParagraph)i.next();
            SVGUtils.styledTextToSAX(handler, para);
        }
    }

    public static void styledTextToSAX(ContentHandler handler, StyledTextParagraph para) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        String decoration = "";
        if (para.isUnderline()) {
            decoration = decoration + "underline ";
        }
        if (para.isOverline()) {
            decoration = decoration + "overline ";
        }
        if (decoration.length() > 0) {
            SVGUtils.addAttribute(atts, "text-decoration", decoration);
        }
        if (para.getLineIndex() > 0) {
            SVGUtils.addAttribute(atts, "dy", "1.3em");
        }
        if (para.isNewline()) {
            SVGUtils.addAttribute(atts, "x", "" + para.getInsertPoint().getX());
            para.setNewline(false);
        }
        if (para.getValign() == 2) {
            SVGUtils.addAttribute(atts, "baseline-shift", "-100%");
        } else if (para.getValign() == 0) {
            SVGUtils.addAttribute(atts, "baseline-shift", "sub");
        } else if (para.getValign() == 4) {
            SVGUtils.addAttribute(atts, "baseline-shift", "-40%");
        }
        if (para.getWidth() > 0.0) {
            SVGUtils.addAttribute(atts, "textLength", "" + para.getWidth());
        }
        if (para.isBold()) {
            SVGUtils.addAttribute(atts, "font-weight", "bold");
        }
        if (para.isItalic()) {
            SVGUtils.addAttribute(atts, "font-style", "italic");
        }
        if (para.getFont().length() > 0) {
            SVGUtils.addAttribute(atts, "font-family", para.getFont());
        }
        if (para.getFontHeight() > 0.0) {
            SVGUtils.addAttribute(atts, "font-size", "" + SVGUtils.formatNumberAttribute(para.getFontHeight()));
        }
        SVGUtils.startElement(handler, "tspan", atts);
        SVGUtils.characters(handler, para.getText());
        SVGUtils.endElement(handler, "tspan");
    }

    public static String formatNumberAttribute(double v) {
        return format.format(v);
    }

    public static String fileToURI(File file) {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("file://");
            char[] c = file.toURL().toExternalForm().toCharArray();
            for (int i = 5; i < c.length; ++i) {
                if (Character.isWhitespace(c[i])) {
                    buf.append("%20");
                    continue;
                }
                buf.append(c[i]);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public static String pathToURI(String path) {
        StringBuffer buf = new StringBuffer();
        char[] c = path.toCharArray();
        if (c.length > 0) {
            buf.append("file://");
            if (c[0] != '/') {
                buf.append('/');
            }
            for (int i = 0; i < c.length; ++i) {
                if (Character.isWhitespace(c[i])) {
                    buf.append("%20");
                    continue;
                }
                if (c[i] == '\\') {
                    buf.append('/');
                    continue;
                }
                buf.append(c[i]);
            }
        }
        return buf.toString();
    }

    public static String lineWeightToStrokeWidth(int lineWeight) {
        double w = (double)lineWeight / 100.0;
        return "" + w + "mm";
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format = new DecimalFormat("###.###################################", symbols);
    }
}

