/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.kabeja.svg.SVGGenerationException;
import org.kabeja.svg.SVGPathBoundaryGenerator;
import org.kabeja.svg.SVGSAXGenerator;
import org.kabeja.svg.generators.SVG3DFaceGenerator;
import org.kabeja.svg.generators.SVG3DSolidGenerator;
import org.kabeja.svg.generators.SVGArcGenerator;
import org.kabeja.svg.generators.SVGAttribGenerator;
import org.kabeja.svg.generators.SVGCircleGenerator;
import org.kabeja.svg.generators.SVGDimensionGenerator;
import org.kabeja.svg.generators.SVGEllipseGenerator;
import org.kabeja.svg.generators.SVGHatchGenerator;
import org.kabeja.svg.generators.SVGImageGenerator;
import org.kabeja.svg.generators.SVGInsertGenerator;
import org.kabeja.svg.generators.SVGLWPolylineGenerator;
import org.kabeja.svg.generators.SVGLeaderGenerator;
import org.kabeja.svg.generators.SVGLineGenerator;
import org.kabeja.svg.generators.SVGMLineGenerator;
import org.kabeja.svg.generators.SVGMTextGenerator;
import org.kabeja.svg.generators.SVGPointGenerator;
import org.kabeja.svg.generators.SVGPolylineGenerator;
import org.kabeja.svg.generators.SVGRayGenerator;
import org.kabeja.svg.generators.SVGShapeGenerator;
import org.kabeja.svg.generators.SVGSolidGenerator;
import org.kabeja.svg.generators.SVGSplineGenerator;
import org.kabeja.svg.generators.SVGTextGenerator;
import org.kabeja.svg.generators.SVGToleranceGenerator;
import org.kabeja.svg.generators.SVGTraceGenerator;
import org.kabeja.svg.generators.SVGViewportGenerator;
import org.kabeja.svg.generators.SVGXLineGenerator;

public class SVGSAXGeneratorManager {
    protected Map generators = new HashMap();
    protected Map pathBoundaryGenerator = new HashMap();

    public SVGSAXGeneratorManager() {
        this.initialize();
    }

    public SVGSAXGenerator getSVGGenerator(String entityType) throws SVGGenerationException {
        SVGSAXGenerator gen = (SVGSAXGenerator)this.generators.get(entityType);
        if (gen == null) {
            throw new SVGGenerationException("EntityType:" + entityType + " not supported");
        }
        return gen;
    }

    public SVGPathBoundaryGenerator getSVGPathBoundaryGenerator(String type) {
        return (SVGPathBoundaryGenerator)this.pathBoundaryGenerator.get(type);
    }

    public void setSVGSAXGenerator(SVGSAXGenerator generator, String entityType) {
        this.generators.put(entityType, generator);
    }

    protected void initialize() {
        this.generators.put("3DFACE", new SVG3DFaceGenerator());
        this.generators.put("3DSOLID", new SVG3DSolidGenerator());
        this.generators.put("ARC", new SVGArcGenerator());
        this.generators.put("ATTRIB", new SVGAttribGenerator());
        this.generators.put("CIRCLE", new SVGCircleGenerator());
        this.generators.put("DIMENSION", new SVGDimensionGenerator());
        this.generators.put("ELLIPSE", new SVGEllipseGenerator());
        this.generators.put("HATCH", new SVGHatchGenerator());
        this.generators.put("IMAGE", new SVGImageGenerator());
        this.generators.put("INSERT", new SVGInsertGenerator());
        this.generators.put("LEADER", new SVGLeaderGenerator());
        this.generators.put("LINE", new SVGLineGenerator());
        this.generators.put("LWPOLYLINE", new SVGLWPolylineGenerator());
        this.generators.put("MLINE", new SVGMLineGenerator());
        this.generators.put("MTEXT", new SVGMTextGenerator());
        this.generators.put("POINT", new SVGPointGenerator());
        this.generators.put("POLYLINE", new SVGPolylineGenerator());
        this.generators.put("RAY", new SVGRayGenerator());
        this.generators.put("SHAPE", new SVGShapeGenerator());
        this.generators.put("SOLID", new SVGSolidGenerator());
        this.generators.put("SPLINE", new SVGSplineGenerator());
        this.generators.put("TEXT", new SVGTextGenerator());
        this.generators.put("TOLERANCE", new SVGToleranceGenerator());
        this.generators.put("TRACE", new SVGTraceGenerator());
        this.generators.put("VIEWPORT", new SVGViewportGenerator());
        this.generators.put("XLINE", new SVGXLineGenerator());
        Iterator i = this.generators.keySet().iterator();
        while (i.hasNext()) {
            String type = (String)i.next();
            Object obj = this.generators.get(type);
            if (!(obj instanceof SVGPathBoundaryGenerator)) continue;
            this.pathBoundaryGenerator.put(type, obj);
        }
    }
}

