/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFInsert;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGInsertGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFInsert insert = (DXFInsert)entity;
        DXFBlock block = insert.getDXFDocument().getDXFBlock(insert.getBlockID());
        StringBuffer buf = new StringBuffer();
        Point referencePoint = block.getReferencePoint();
        int rows = insert.getRows();
        int columns = insert.getColumns();
        double rotate = insert.getRotate();
        Point insertPoint = insert.getPoint();
        double scale_x = insert.getScaleX();
        double scale_y = insert.getScaleY();
        double column_spacing = insert.getColumnSpacing();
        double row_spacing = insert.getRowSpacing();
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                buf.append("translate(");
                buf.append(SVGUtils.formatNumberAttribute(insertPoint.getX() - column_spacing * (double)column));
                buf.append(" ");
                buf.append(SVGUtils.formatNumberAttribute(insertPoint.getY() - row_spacing * (double)row));
                buf.append(")");
                if (rotate != 0.0) {
                    buf.append(" rotate(");
                    buf.append(SVGUtils.formatNumberAttribute(rotate));
                    buf.append(")");
                }
                if (scale_x != 1.0 || scale_y != 1.0) {
                    buf.append(" scale(");
                    buf.append(SVGUtils.formatNumberAttribute(scale_x));
                    buf.append(" ");
                    buf.append(SVGUtils.formatNumberAttribute(scale_y));
                    buf.append(")");
                }
                if (referencePoint.getX() != 0.0 || referencePoint.getY() != 0.0) {
                    buf.append(" translate(");
                    buf.append(SVGUtils.formatNumberAttribute(-1.0 * referencePoint.getX()));
                    buf.append(" ");
                    buf.append(SVGUtils.formatNumberAttribute(-1.0 * referencePoint.getY()));
                    buf.append(")");
                }
                AttributesImpl attr = new AttributesImpl();
                SVGUtils.addAttribute(attr, "transform", buf.toString());
                super.setCommonAttributes(attr, svgContext, (DXFEntity)insert);
                if (scale_x + scale_y != 0.0 && svgContext.containsKey(SVGContext.LAYER_STROKE_WIDTH)) {
                    Double lw = (Double)svgContext.get(SVGContext.LAYER_STROKE_WIDTH);
                    double width = lw * 2.0 / (scale_x + scale_y);
                    SVGUtils.addAttribute(attr, "stroke-width", SVGUtils.formatNumberAttribute(width));
                }
                attr.addAttribute("http://www.w3.org/2000/xmlns/", "xlink", "xmlns:xlink", "CDATA", "http://www.w3.org/1999/xlink");
                attr.addAttribute("http://www.w3.org/1999/xlink", "href", "xlink:href", "CDATA", "#" + SVGUtils.validateID(insert.getBlockID()));
                SVGUtils.emptyElement(handler, "use", attr);
                buf.delete(0, buf.length());
            }
        }
    }
}

