/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.parser.Parser;
import org.kabeja.parser.ParserBuilder;
import org.kabeja.processing.ProcessPipeline;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.tools.SAXProcessingManagerBuilder;
import org.kabeja.ui.impl.ServiceContainer;
import org.kabeja.ui.xml.SAXServiceContainerBuilder;

public class Main {
    private String encoding = "";
    private String sourceFile;
    private String destinationFile;
    private Parser parser;
    private boolean process = false;
    private boolean directoryMode = true;
    private ProcessingManager processorManager;
    private String pipeline;
    private boolean nogui = false;

    public static void main(String[] stringArray) {
        Main main = new Main();
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-pp")) {
                try {
                    main.setProcessConfig(new FileInputStream(stringArray[n + 1]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                n += 2;
                continue;
            }
            if (stringArray[n].equals("-pipeline")) {
                main.setPipeline(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("--help")) {
                ++n;
                bl2 = true;
                continue;
            }
            if (stringArray[n].equals("-nogui")) {
                main.omitUI(true);
                ++n;
                continue;
            }
            if (bl) {
                main.setSourceFile(stringArray[n]);
                bl = false;
                ++n;
                continue;
            }
            main.setDestinationFile(stringArray[n]);
            ++n;
        }
        main.initialize();
        if (bl2 || stringArray.length == 1 && main.isNogui()) {
            Main.printUsage();
            main.printPipelines();
        } else {
            main.process();
        }
    }

    private static void printUsage() {
        System.out.println("\n Use: java -jar kabeja.jar <Options> sourcefile  <outputfile>\n\nOptions:\n  --help shows this and exit\n  -nogui run only the cli, omit the user interface\n  -pp process.xml set processing file to use\n  -pipeline name  process the given pipeline\n\nIf the source is a directory, all containing files will be converted.\n");
    }

    public void initialize() {
        if (this.processorManager == null) {
            this.setProcessConfig(this.getClass().getResourceAsStream("/conf/process.xml"));
        }
    }

    public void process() {
        if (this.parser == null) {
            this.parser = ParserBuilder.createDefaultParser();
        }
        if (this.nogui) {
            File file = new File(this.sourceFile);
            if (file.exists() && file.isFile()) {
                this.parseFile(file, this.destinationFile);
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].getName().toLowerCase().endsWith(".dxf")) continue;
                    try {
                        String string = fileArray[i].getCanonicalPath();
                        String string2 = null;
                        String string3 = string.substring(0, string.toLowerCase().lastIndexOf(".dxf")) + string2;
                        System.out.println("convert file:" + string);
                        this.parseFile(fileArray[i], string3);
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                System.err.println("Cannot open " + this.sourceFile);
            }
        } else {
            try {
                ServiceContainer serviceContainer = SAXServiceContainerBuilder.buildFromStream(new FileInputStream("conf/ui.xml"));
                serviceContainer.setProcessingManager(this.processorManager);
                serviceContainer.start();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String string) {
        this.sourceFile = string;
    }

    public String getDestinationFile() {
        return this.destinationFile;
    }

    public void setDestinationFile(String string) {
        this.destinationFile = string;
        this.directoryMode = false;
    }

    private void parseFile(File file, String string) {
        try {
            this.parser.parse(new FileInputStream(file), this.encoding);
            DXFDocument dXFDocument = this.parser.getDocument();
            if (this.process) {
                if (this.directoryMode) {
                    this.processorManager.process(dXFDocument, new HashMap(), this.pipeline, file.getAbsolutePath());
                } else {
                    this.processorManager.process(dXFDocument, new HashMap(), this.pipeline, new FileOutputStream(string));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setParserConfigFile(String string) {
        this.parser = ParserBuilder.buildFromXML(string);
    }

    public void setProcessConfig(InputStream inputStream) {
        this.processorManager = SAXProcessingManagerBuilder.buildFromStream(inputStream);
    }

    public void setPipeline(String string) {
        this.pipeline = string;
        this.process = true;
    }

    public void omitUI(boolean bl) {
        this.nogui = bl;
    }

    public void printPipelines() {
        Iterator iterator = this.processorManager.getProcessPipelines().keySet().iterator();
        System.out.println("\n Available pipelines:\n----------\n");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ProcessPipeline processPipeline = this.processorManager.getProcessPipeline(string);
            System.out.print(" " + string);
            if (processPipeline.getDescription().length() > 0) {
                System.out.print("\t" + processPipeline.getDescription());
            }
            System.out.println();
        }
    }

    public boolean isNogui() {
        return this.nogui;
    }
}

