/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf;

import java.util.ArrayList;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.objects.DXFImageDefObject;

public class DXFImage
extends DXFEntity {
    protected Point insertPoint = new Point();
    protected Point vectorV = new Point();
    protected Point vectorU = new Point();
    protected double imageSizeAlongU;
    protected double imageSizeAlongV;
    protected String imageDefID = "";
    protected double brightness;
    protected double contrast;
    protected double fade;
    protected ArrayList clipBoundary = new ArrayList();
    protected boolean clipping = false;
    protected boolean rectangularClipping = false;
    protected boolean polygonalClipping = false;

    public Bounds getBounds() {
        Bounds bounds = new Bounds();
        DXFImageDefObject dXFImageDefObject = (DXFImageDefObject)this.doc.getDXFObjectByID(this.getImageDefObjectID());
        if (dXFImageDefObject != null) {
            bounds.addToBounds(this.insertPoint);
            bounds.addToBounds(this.insertPoint.getX() + this.imageSizeAlongU, this.insertPoint.getY() + this.imageSizeAlongV, this.insertPoint.getZ());
        } else {
            bounds.setValid(false);
        }
        return bounds;
    }

    public String getType() {
        return "IMAGE";
    }

    public Point getInsertPoint() {
        return this.insertPoint;
    }

    public void setInsertPoint(Point point) {
        this.insertPoint = point;
    }

    public void setImageDefObjectID(String string) {
        this.imageDefID = string;
    }

    public String getImageDefObjectID() {
        return this.imageDefID;
    }

    public double getImageSizeAlongU() {
        return this.imageSizeAlongU;
    }

    public void setImageSizeAlongU(double d) {
        this.imageSizeAlongU = d;
    }

    public double getImageSizeAlongV() {
        return this.imageSizeAlongV;
    }

    public void setImageSizeAlongV(double d) {
        this.imageSizeAlongV = d;
    }

    public Point getVectorU() {
        return this.vectorU;
    }

    public void setVectorU(Point point) {
        this.vectorU = point;
    }

    public Point getVectorV() {
        return this.vectorV;
    }

    public void setVectorV(Point point) {
        this.vectorV = point;
    }

    public double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(double d) {
        this.brightness = d;
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean bl) {
        this.clipping = bl;
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setContrast(double d) {
        this.contrast = d;
    }

    public double getFade() {
        return this.fade;
    }

    public void setFade(double d) {
        this.fade = d;
    }

    public ArrayList getClipBoundary() {
        return this.clipBoundary;
    }

    public void addClippingPoint(Point point) {
        this.clipBoundary.add(point);
    }

    public boolean isPolygonalClipping() {
        return this.polygonalClipping;
    }

    public void setPolygonalClipping(boolean bl) {
        this.polygonalClipping = bl;
        this.rectangularClipping = !bl;
    }

    public boolean isRectangularClipping() {
        return this.rectangularClipping;
    }

    public void setRectangularClipping(boolean bl) {
        this.rectangularClipping = bl;
        this.polygonalClipping = !bl;
    }

    public double getLength() {
        return 0.0;
    }
}

