/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLWPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFLWPolylineHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "LWPOLYLINE";
    public static final int VERTEX_BULGE = 42;
    public static final int START_WIDTH = 40;
    public static final int END_WIDTH = 41;
    public static final int CONSTANT_WIDTH = 43;
    public static final int ELEVATION = 38;
    public static final int THICKNESS = 39;
    private DXFVertex vertex;
    private DXFLWPolyline lwpolyline;

    public void endDXFEntity() {
    }

    public DXFEntity getDXFEntity() {
        return this.lwpolyline;
    }

    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    public boolean isFollowSequence() {
        return false;
    }

    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.createVertex();
                this.vertex.setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.vertex.setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.vertex.setZ(dXFValue.getDoubleValue());
                break;
            }
            case 42: {
                this.vertex.setBulge(dXFValue.getDoubleValue());
                break;
            }
            case 40: {
                this.vertex.setStartWidth(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                this.vertex.setEndWidth(dXFValue.getDoubleValue());
                break;
            }
            case 43: {
                this.lwpolyline.setConstantWidth(dXFValue.getDoubleValue());
                break;
            }
            case 38: {
                this.lwpolyline.setElevation(dXFValue.getDoubleValue());
                break;
            }
            case 39: {
                this.lwpolyline.setThickness(dXFValue.getDoubleValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.lwpolyline);
            }
        }
    }

    public void startDXFEntity() {
        this.lwpolyline = new DXFLWPolyline();
    }

    private void createVertex() {
        this.vertex = new DXFVertex();
        this.vertex.setDXFDocument(this.doc);
        this.lwpolyline.addVertex(this.vertex);
    }
}

