/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser.entities;

import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLeader;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.entities.AbstractEntityHandler;

public class DXFLeaderHandler
extends AbstractEntityHandler {
    public static final int GROUPCODE_ARROW_HEAD_FLAG = 71;
    public static final int GROUPCODE_LEADER_PATH_TYPE = 72;
    public static final int GROUPCODE_LEADER_CREATION_FLAG = 73;
    public static final int GROUPCODE_HOOKLINE_DIRECTION_FLAG = 74;
    public static final int GROUPCODE_HOOKLINE_FLAG = 75;
    public static final int GROUPCODE_TEXT_HEIGHT = 40;
    public static final int GROUPCODE_TEXT_WIDTH = 41;
    public static final int GROUPCODE_COLOR_LEADER = 77;
    public static final int GROUPCODE_TEXT_ENTITY_REFERENCE = 340;
    public static final int GROUPCODE_HORIZONTAL_DIRECTION_X = 211;
    public static final int GROUPCODE_HORIZONTAL_DIRECTION_Y = 221;
    public static final int GROUPCODE_HORIZONTAL_DIRECTION_Z = 231;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_INSERTPOINT_X = 212;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_INSERTPOINT_Y = 222;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_INSERTPOINT_Z = 232;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_PLACEMENT_POINT_X = 213;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_PLACEMENT_POINT_Y = 223;
    public static final int GROUPCODE_OFFSET_LAST_VERTEX_PLACEMENT_POINT_Z = 233;
    protected DXFLeader leader;
    protected Point vertex;

    public String getDXFEntityName() {
        return "LEADER";
    }

    public void startDXFEntity() {
        this.leader = new DXFLeader();
    }

    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.vertex = new Point();
                this.leader.addCoordinate(this.vertex);
                this.vertex.setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.vertex.setY(dXFValue.getDoubleValue());
                break;
            }
            case 30: {
                this.vertex.setZ(dXFValue.getDoubleValue());
                break;
            }
            case 3: {
                this.leader.setStyleNameID(dXFValue.getValue());
                break;
            }
            case 71: {
                this.leader.setArrowEnabled(dXFValue.getBooleanValue());
                break;
            }
            case 72: {
                this.leader.setPathType(dXFValue.getIntegerValue());
                break;
            }
            case 73: {
                this.leader.setCreationType(dXFValue.getIntegerValue());
                break;
            }
            case 74: {
                this.leader.setHooklineDirecton(dXFValue.getIntegerValue());
                break;
            }
            case 75: {
                this.leader.setHookline(dXFValue.getBooleanValue());
                break;
            }
            case 40: {
                this.leader.setTextHeight(dXFValue.getDoubleValue());
                break;
            }
            case 41: {
                this.leader.setTextWidth(dXFValue.getDoubleValue());
                break;
            }
            case 211: {
                this.leader.getHorizontalDirection().setX(dXFValue.getDoubleValue());
                break;
            }
            case 221: {
                this.leader.getHorizontalDirection().setY(dXFValue.getDoubleValue());
                break;
            }
            case 231: {
                this.leader.getHorizontalDirection().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 212: {
                this.leader.getLastOffsetInsertion().setX(dXFValue.getDoubleValue());
                break;
            }
            case 222: {
                this.leader.getLastOffsetInsertion().setY(dXFValue.getDoubleValue());
                break;
            }
            case 232: {
                this.leader.getLastOffsetInsertion().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 213: {
                this.leader.getLastOffsetText().setX(dXFValue.getDoubleValue());
                break;
            }
            case 223: {
                this.leader.getLastOffsetText().setY(dXFValue.getDoubleValue());
                break;
            }
            case 233: {
                this.leader.getLastOffsetText().setZ(dXFValue.getDoubleValue());
                break;
            }
            case 340: {
                this.leader.setTextID(dXFValue.getValue());
                break;
            }
            case 77: {
                this.leader.setColor(dXFValue.getIntegerValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.leader);
            }
        }
    }

    public DXFEntity getDXFEntity() {
        return this.leader;
    }

    public void endDXFEntity() {
    }

    public boolean isFollowSequence() {
        return false;
    }
}

