/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kabeja.dxf.DXFArc;
import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLWPolyline;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;
import org.kabeja.processing.helper.PolylineQueue;

public class PolylineConverter
extends AbstractPostProcessor {
    public static final String PROPERTY_POINT_DISTANCE = "point.distance";
    private List queues;
    private double radius = DXFConstants.POINT_CONNECTION_RADIUS;

    public void process(DXFDocument dXFDocument, Map map) throws ProcessorException {
        Iterator iterator = dXFDocument.getDXFLayerIterator();
        while (iterator.hasNext()) {
            DXFLayer dXFLayer = (DXFLayer)iterator.next();
            this.processLayer(dXFLayer);
        }
    }

    public void setProperties(Map map) {
        if (map.containsKey(PROPERTY_POINT_DISTANCE)) {
            this.radius = Double.parseDouble((String)map.get(PROPERTY_POINT_DISTANCE));
        }
    }

    protected void processLayer(DXFLayer dXFLayer) {
        Point point;
        Point point2;
        DXFEntity dXFEntity;
        Iterator iterator;
        List list;
        this.queues = new ArrayList();
        if (dXFLayer.hasDXFEntities("LINE")) {
            list = dXFLayer.getDXFEntities("LINE");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                dXFEntity = (DXFLine)iterator.next();
                point2 = ((DXFLine)dXFEntity).getStartPoint();
                point = ((DXFLine)dXFEntity).getEndPoint();
                this.checkDXFEntity(dXFEntity, point2, point);
            }
        }
        if (dXFLayer.hasDXFEntities("POLYLINE")) {
            list = dXFLayer.getDXFEntities("POLYLINE");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                dXFEntity = (DXFPolyline)iterator.next();
                if (((DXFPolyline)dXFEntity).isClosed() || ((DXFPolyline)dXFEntity).is3DPolygonMesh() || ((DXFPolyline)dXFEntity).isClosedMeshMDirection() || ((DXFPolyline)dXFEntity).isClosedMeshNDirection() || ((DXFPolyline)dXFEntity).isCubicSurefaceMesh()) continue;
                point2 = ((DXFPolyline)dXFEntity).getVertex(0).getPoint();
                point = ((DXFPolyline)dXFEntity).getVertex(((DXFPolyline)dXFEntity).getVertexCount() - 1).getPoint();
                this.checkDXFEntity(dXFEntity, point2, point);
            }
        }
        if (dXFLayer.hasDXFEntities("LWPOLYLINE")) {
            list = dXFLayer.getDXFEntities("LWPOLYLINE");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                dXFEntity = (DXFLWPolyline)iterator.next();
                if (((DXFPolyline)dXFEntity).isClosed() || ((DXFPolyline)dXFEntity).is3DPolygonMesh() || ((DXFPolyline)dXFEntity).isClosedMeshMDirection() || ((DXFPolyline)dXFEntity).isClosedMeshNDirection() || ((DXFPolyline)dXFEntity).isCubicSurefaceMesh()) continue;
                point2 = ((DXFPolyline)dXFEntity).getVertex(0).getPoint();
                point = ((DXFPolyline)dXFEntity).getVertex(((DXFPolyline)dXFEntity).getVertexCount() - 1).getPoint();
                this.checkDXFEntity(dXFEntity, point2, point);
            }
        }
        if (dXFLayer.hasDXFEntities("ARC")) {
            list = dXFLayer.getDXFEntities("ARC");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                dXFEntity = (DXFArc)iterator.next();
                point2 = ((DXFArc)dXFEntity).getStartPoint();
                point = ((DXFArc)dXFEntity).getEndPoint();
                this.checkDXFEntity(dXFEntity, point2, point);
            }
        }
        this.connectPolylineQueues();
        this.cleanUp(dXFLayer);
    }

    protected void checkDXFEntity(DXFEntity dXFEntity, Point point, Point point2) {
        PolylineQueue polylineQueue;
        Iterator iterator = this.queues.iterator();
        while (iterator.hasNext()) {
            polylineQueue = (PolylineQueue)iterator.next();
            if (!polylineQueue.connectDXFEntity(dXFEntity, point, point2)) continue;
            return;
        }
        polylineQueue = new PolylineQueue(dXFEntity, point, point2, this.radius);
        this.queues.add(polylineQueue);
    }

    protected void cleanUp(DXFLayer dXFLayer) {
        Iterator iterator = this.queues.iterator();
        while (iterator.hasNext()) {
            PolylineQueue polylineQueue = (PolylineQueue)iterator.next();
            if (polylineQueue.size() > 1) {
                polylineQueue.createDXFPolyline(dXFLayer);
                continue;
            }
            iterator.remove();
        }
    }

    protected void connectPolylineQueues() {
        for (int i = 0; i < this.queues.size(); ++i) {
            PolylineQueue polylineQueue = (PolylineQueue)this.queues.get(i);
            boolean bl = false;
            for (int j = i + 1; j < this.queues.size() && !bl; ++j) {
                if (!((PolylineQueue)this.queues.get(j)).connect(polylineQueue)) continue;
                this.queues.remove(i);
                --i;
                bl = true;
            }
        }
    }
}

