/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFViewport;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;

public class ViewportFilter
extends AbstractPostProcessor {
    public void process(DXFDocument dXFDocument, Map map) throws ProcessorException {
        DXFViewport dXFViewport = null;
        Iterator iterator = dXFDocument.getDXFViewportIterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            DXFViewport dXFViewport2 = (DXFViewport)iterator.next();
            if (!dXFViewport2.isActive()) continue;
            dXFViewport = dXFViewport2;
            bl = true;
        }
        if (dXFViewport != null) {
            double d = dXFViewport.getHeight() / 2.0;
            double d2 = dXFViewport.getHeight() * dXFViewport.getAspectRatio() / 2.0;
            Bounds bounds = new Bounds();
            bounds.addToBounds(dXFViewport.getCenterPoint().getX() + d2, dXFViewport.getCenterPoint().getY() + d, dXFViewport.getCenterPoint().getZ());
            bounds.addToBounds(dXFViewport.getCenterPoint().getX() - d2, dXFViewport.getCenterPoint().getY() - d, dXFViewport.getCenterPoint().getZ());
            this.filterEntities(bounds, dXFDocument);
        }
    }

    protected void filterEntities(Bounds bounds, DXFDocument dXFDocument) {
        Iterator iterator = dXFDocument.getDXFLayerIterator();
        while (iterator.hasNext()) {
            DXFLayer dXFLayer = (DXFLayer)iterator.next();
            Iterator iterator2 = dXFLayer.getDXFEntityTypeIterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                Iterator iterator3 = dXFLayer.getDXFEntities(string).iterator();
                while (iterator3.hasNext()) {
                    DXFEntity dXFEntity = (DXFEntity)iterator3.next();
                    Bounds bounds2 = dXFEntity.getBounds();
                    if (bounds.contains(bounds2)) continue;
                    iterator3.remove();
                }
            }
        }
    }

    public void setProperties(Map map) {
    }
}

