/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.kabeja.ui.impl.ProcessingRunViewComponent;

public class DXFFileTransferHandler
extends TransferHandler {
    private ProcessingRunViewComponent c;

    public DXFFileTransferHandler(ProcessingRunViewComponent processingRunViewComponent) {
        this.c = processingRunViewComponent;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        int n;
        for (n = 0; n < dataFlavorArray.length; ++n) {
            if (!dataFlavorArray[n].isFlavorJavaFileListType()) continue;
            return true;
        }
        for (n = 0; n < dataFlavorArray.length; ++n) {
            if (!dataFlavorArray[n].isFlavorTextType()) continue;
            return true;
        }
        return false;
    }

    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getFileList(Transferable transferable) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() <= 0) return arrayList;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    arrayList.add(file);
                }
                return arrayList;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                return arrayList;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return arrayList;
            }
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) return arrayList;
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            String[] stringArray = string.split("\n");
            if (stringArray.length <= 0) return arrayList;
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (file.exists()) {
                    arrayList.add(file);
                    continue;
                }
                if (!stringArray[i].startsWith("file:")) continue;
                try {
                    file = new File(new URI(stringArray[i].trim()));
                    arrayList.add(file);
                    continue;
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            }
            return arrayList;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            return arrayList;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        List list = this.getFileList(transferable);
        if (list.size() > 0) {
            File file = (File)list.get(0);
            if (file.getAbsolutePath().toLowerCase().endsWith(".dxf")) {
                this.c.processInput(file);
            }
            return true;
        }
        return false;
    }
}

