/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import java.util.Iterator;
import java.util.Vector;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractSVGTransform;
import org.apache.batik.dom.svg.SVGOMTransform;
import org.w3c.dom.svg.SVGMatrix;

public class AnimatableTransformListValue
extends AnimatableValue {
    protected Vector transforms;

    protected AnimatableTransformListValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableTransformListValue(AnimationTarget animationTarget, AbstractSVGTransform abstractSVGTransform) {
        super(animationTarget);
        this.transforms = new Vector();
        this.transforms.add(abstractSVGTransform);
    }

    public AnimatableTransformListValue(AnimationTarget animationTarget, Vector vector) {
        super(animationTarget);
        int n = vector.size();
        this.transforms = new Vector(n);
        this.transforms.setSize(n);
        for (int i = 0; i < n; ++i) {
            this.transforms.setElementAt(vector.elementAt(i), i);
        }
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        int n2;
        AnimatableTransformListValue animatableTransformListValue;
        AnimatableTransformListValue animatableTransformListValue2 = (AnimatableTransformListValue)animatableValue2;
        AnimatableTransformListValue animatableTransformListValue3 = (AnimatableTransformListValue)animatableValue3;
        int n3 = animatableValue3 == null ? 0 : animatableTransformListValue3.transforms.size();
        int n4 = 1 + n3 * n;
        if (animatableValue == null) {
            animatableTransformListValue = new AnimatableTransformListValue(this.target);
            animatableTransformListValue.transforms = new Vector(n4);
            animatableTransformListValue.transforms.setSize(n4);
        } else {
            animatableTransformListValue = (AnimatableTransformListValue)animatableValue;
            if (animatableTransformListValue.transforms == null) {
                animatableTransformListValue.transforms = new Vector(n4);
                animatableTransformListValue.transforms.setSize(n4);
            } else if (animatableTransformListValue.transforms.size() != n4) {
                animatableTransformListValue.transforms.setSize(n4);
            }
        }
        for (int i = 0; i < n3; ++i) {
            for (n2 = i; n2 < i + n; ++n2) {
                animatableTransformListValue.transforms.setElementAt(animatableTransformListValue3.transforms.elementAt(i), n2);
            }
        }
        if (animatableValue2 != null) {
            AbstractSVGTransform abstractSVGTransform;
            AbstractSVGTransform abstractSVGTransform2 = (AbstractSVGTransform)this.transforms.lastElement();
            n2 = abstractSVGTransform2.getType();
            if (n2 == (abstractSVGTransform = (AbstractSVGTransform)animatableTransformListValue2.transforms.lastElement()).getType()) {
                AbstractSVGTransform abstractSVGTransform3 = (AbstractSVGTransform)animatableTransformListValue.transforms.elementAt(n4 - 1);
                if (abstractSVGTransform3 == null) {
                    abstractSVGTransform3 = new SVGOMTransform();
                    animatableTransformListValue.transforms.setElementAt(abstractSVGTransform3, n4 - 1);
                }
                float f2 = 0.0f;
                switch (n2) {
                    case 5: 
                    case 6: {
                        f2 = abstractSVGTransform2.getAngle();
                        f2 += f * (abstractSVGTransform.getAngle() - f2);
                        if (n2 == 5) {
                            abstractSVGTransform3.setSkewX(f2);
                            break;
                        }
                        if (n2 != 6) break;
                        abstractSVGTransform3.setSkewY(f2);
                        break;
                    }
                    case 3: {
                        SVGMatrix sVGMatrix = abstractSVGTransform2.getMatrix();
                        SVGMatrix sVGMatrix2 = abstractSVGTransform.getMatrix();
                        float f3 = sVGMatrix.getA();
                        float f4 = sVGMatrix.getD();
                        f3 += f * (sVGMatrix2.getA() - f3);
                        f4 += f * (sVGMatrix2.getD() - f4);
                        if (n2 == 2) {
                            abstractSVGTransform3.setTranslate(f3, f4);
                            break;
                        }
                        if (n2 == 3) {
                            abstractSVGTransform3.setScale(f3, f4);
                            break;
                        }
                        abstractSVGTransform3.setRotate(f2, f3, f4);
                        break;
                    }
                    case 4: {
                        float f5 = abstractSVGTransform2.getX();
                        float f6 = abstractSVGTransform2.getY();
                        f5 += f * (abstractSVGTransform.getX() - f5);
                        f6 += f * (abstractSVGTransform.getY() - f6);
                        f2 = abstractSVGTransform2.getAngle();
                        f2 += f * (abstractSVGTransform.getAngle() - f2);
                        abstractSVGTransform3.setRotate(f2, f5, f6);
                        break;
                    }
                    case 2: {
                        SVGMatrix sVGMatrix = abstractSVGTransform2.getMatrix();
                        SVGMatrix sVGMatrix3 = abstractSVGTransform.getMatrix();
                        float f7 = sVGMatrix.getE();
                        float f8 = sVGMatrix.getF();
                        f7 += f * (sVGMatrix3.getE() - f7);
                        f8 += f * (sVGMatrix3.getF() - f8);
                        if (n2 == 2) {
                            abstractSVGTransform3.setTranslate(f7, f8);
                            break;
                        }
                        if (n2 == 3) {
                            abstractSVGTransform3.setScale(f7, f8);
                            break;
                        }
                        abstractSVGTransform3.setRotate(f2, f7, f8);
                    }
                }
            }
        } else {
            AbstractSVGTransform abstractSVGTransform = (AbstractSVGTransform)this.transforms.lastElement();
            AbstractSVGTransform abstractSVGTransform4 = (AbstractSVGTransform)animatableTransformListValue.transforms.elementAt(n4 - 1);
            if (abstractSVGTransform4 == null) {
                abstractSVGTransform4 = new SVGOMTransform();
                animatableTransformListValue.transforms.setElementAt(abstractSVGTransform4, n4 - 1);
            }
            abstractSVGTransform4.assign(abstractSVGTransform);
        }
        animatableTransformListValue.hasChanged = true;
        return animatableTransformListValue;
    }

    public Iterator getTransforms() {
        return this.transforms.iterator();
    }

    public boolean canPace() {
        return true;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        float f;
        AnimatableTransformListValue animatableTransformListValue = (AnimatableTransformListValue)animatableValue;
        if (this.transforms.size() != 1 || animatableTransformListValue.transforms.size() != 1) {
            return 0.0f;
        }
        AbstractSVGTransform abstractSVGTransform = (AbstractSVGTransform)this.transforms.get(0);
        AbstractSVGTransform abstractSVGTransform2 = (AbstractSVGTransform)animatableTransformListValue.transforms.get(0);
        short s = abstractSVGTransform.getType();
        if (s != abstractSVGTransform2.getType()) {
            return 0.0f;
        }
        SVGMatrix sVGMatrix = abstractSVGTransform.getMatrix();
        SVGMatrix sVGMatrix2 = abstractSVGTransform2.getMatrix();
        float f2 = 0.0f;
        switch (s) {
            case 2: {
                f = sVGMatrix.getC() - sVGMatrix2.getC();
                f2 = sVGMatrix.getF() - sVGMatrix2.getF();
                break;
            }
            case 4: {
                f = abstractSVGTransform.getAngle() - abstractSVGTransform2.getAngle();
                break;
            }
            case 3: {
                f = sVGMatrix.getA() - sVGMatrix2.getA();
                f2 = sVGMatrix.getE() - sVGMatrix2.getE();
                break;
            }
            case 5: {
                f = sVGMatrix.getB() - sVGMatrix2.getB();
                break;
            }
            case 6: {
                f = sVGMatrix.getD() - sVGMatrix2.getD();
                break;
            }
            default: {
                return 0.0f;
            }
        }
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableTransformListValue(this.target, new Vector(5));
    }

    public String toStringRep() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.transforms.iterator();
        while (iterator.hasNext()) {
            AbstractSVGTransform abstractSVGTransform = (AbstractSVGTransform)iterator.next();
            SVGMatrix sVGMatrix = abstractSVGTransform.getMatrix();
            switch (abstractSVGTransform.getType()) {
                case 2: {
                    stringBuffer.append("translate(");
                    stringBuffer.append(sVGMatrix.getC());
                    stringBuffer.append(',');
                    stringBuffer.append(sVGMatrix.getF());
                    stringBuffer.append(')');
                    break;
                }
                case 3: {
                    stringBuffer.append("scale(");
                    stringBuffer.append(sVGMatrix.getA());
                    stringBuffer.append(',');
                    stringBuffer.append(sVGMatrix.getE());
                    stringBuffer.append(')');
                    break;
                }
                case 5: {
                    stringBuffer.append("skewX(");
                    stringBuffer.append(sVGMatrix.getB());
                    stringBuffer.append(')');
                    break;
                }
                case 6: {
                    stringBuffer.append("skewY(");
                    stringBuffer.append(sVGMatrix.getD());
                    stringBuffer.append(')');
                    break;
                }
                case 4: {
                    stringBuffer.append("rotate(");
                    stringBuffer.append(abstractSVGTransform.getAngle());
                    stringBuffer.append(',');
                    stringBuffer.append(abstractSVGTransform.getX());
                    stringBuffer.append(',');
                    stringBuffer.append(abstractSVGTransform.getY());
                    stringBuffer.append(')');
                }
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

