/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFMText;
import org.kabeja.dxf.DXFStyle;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGMTextGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        double angle;
        DXFMText mText = (DXFMText)entity;
        AttributesImpl attr = new AttributesImpl();
        Point p = mText.getInsertPoint();
        Point alignmentPoint = new Point(p.getX(), p.getY(), p.getZ());
        boolean notUpsideDown = true;
        DXFStyle style = null;
        if (mText.getTextStyle().length() > 0 && (style = mText.getDXFDocument().getDXFStyle(mText.getTextStyle())) != null) {
            if (style.isBackward()) {
                SVGUtils.addAttribute(attr, "writing-mode", "rl");
            } else {
                SVGUtils.addAttribute(attr, "writing-mode", "lr-tb");
            }
            if (style.isUpsideDown()) {
                notUpsideDown = false;
            }
        } else {
            SVGUtils.addAttribute(attr, "writing-mode", "lr-tb");
        }
        if (notUpsideDown) {
            switch (mText.getAlignment()) {
                case 1: {
                    SVGUtils.addAttribute(attr, "text-anchor", "start");
                    break;
                }
                case 2: {
                    SVGUtils.addAttribute(attr, "text-anchor", "middle");
                    break;
                }
                case 3: {
                    SVGUtils.addAttribute(attr, "text-anchor", "end");
                    break;
                }
                case 4: {
                    SVGUtils.addAttribute(attr, "text-anchor", "start");
                    SVGUtils.addAttribute(attr, "alignment-baseline", "middle");
                    break;
                }
                case 5: {
                    SVGUtils.addAttribute(attr, "text-anchor", "middle");
                    SVGUtils.addAttribute(attr, "alignment-baseline", "middle");
                    break;
                }
                case 6: {
                    SVGUtils.addAttribute(attr, "text-anchor", "end");
                    SVGUtils.addAttribute(attr, "alignment-baseline", "middle");
                    break;
                }
                case 7: {
                    SVGUtils.addAttribute(attr, "text-anchor", "start");
                    break;
                }
                case 8: {
                    SVGUtils.addAttribute(attr, "text-anchor", "middle");
                    break;
                }
                case 9: {
                    SVGUtils.addAttribute(attr, "text-anchor", "end");
                    break;
                }
                default: {
                    SVGUtils.addAttribute(attr, "text-anchor", "start");
                }
            }
        }
        SVGUtils.addAttribute(attr, "x", "" + alignmentPoint.getX());
        SVGUtils.addAttribute(attr, "y", "" + alignmentPoint.getY());
        double height = mText.getHeight();
        if (height >= Double.MAX_VALUE) {
            height = ((Bounds)svgContext.get(SVGContext.DRAFT_BOUNDS)).getHeight() * 0.005;
        }
        SVGUtils.addAttribute(attr, "font-size", SVGUtils.formatNumberAttribute(height));
        StringBuffer transform = new StringBuffer();
        if (!mText.isUpsideDown()) {
            transform.append("matrix(1 0 0 -1 0 ");
            transform.append(2.0 * alignmentPoint.getY());
            transform.append(')');
        }
        if ((angle = mText.getRotation()) != 0.0) {
            transform.append(" rotate(");
            transform.append(-1.0 * angle);
            transform.append(' ');
            transform.append(alignmentPoint.getX());
            transform.append(' ');
            transform.append(alignmentPoint.getY());
            transform.append(" )");
        }
        if (mText.getObliqueAngle() != 0.0) {
            transform.append(" skewX(");
            transform.append(-1.0 * mText.getObliqueAngle());
            transform.append(')');
            transform.append(" translate( ");
            transform.append(alignmentPoint.getY() * Math.tan(Math.toRadians(1.0 * mText.getObliqueAngle())));
            transform.append(')');
        }
        SVGUtils.addAttribute(attr, "transform", transform.toString());
        if (mText.getReferenceWidth() > 0.0) {
            SVGUtils.addAttribute(attr, "textLength", "" + mText.getReferenceWidth());
        }
        SVGUtils.addAttribute(attr, "fill", "currentColor");
        super.setCommonAttributes(attr, svgContext, (DXFEntity)mText);
        SVGUtils.startElement(handler, "text", attr);
        SVGUtils.textDocumentToSAX(handler, mText.getTextDocument());
        SVGUtils.endElement(handler, "text");
    }
}

