/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.Graphics2DImagePainter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSGraphics2D;
import org.apache.fop.render.ps.PSRenderer;

public class PSGraphics2DAdapter
implements Graphics2DAdapter {
    private PSRenderer renderer;

    public PSGraphics2DAdapter(PSRenderer renderer) {
        this.renderer = renderer;
    }

    public void paintImage(Graphics2DImagePainter painter, RendererContext context, int x, int y, int width, int height) throws IOException {
        PSGenerator gen = this.renderer.gen;
        float fwidth = (float)width / 1000.0f;
        float fheight = (float)height / 1000.0f;
        float fx = (float)x / 1000.0f;
        float fy = (float)y / 1000.0f;
        Dimension dim = painter.getImageSize();
        float imw = (float)dim.getWidth() / 1000.0f;
        float imh = (float)dim.getHeight() / 1000.0f;
        float sx = fwidth / imw;
        float sy = fheight / imh;
        gen.commentln("%FOPBeginGraphics2D");
        gen.saveGraphicsState();
        gen.writeln("newpath");
        gen.defineRect(fx, fy, fwidth, fheight);
        gen.writeln("clip");
        gen.concatMatrix(sx, 0.0, 0.0, sy, fx, fy);
        boolean textAsShapes = false;
        PSGraphics2D graphics = new PSGraphics2D(false, gen);
        graphics.setGraphicContext(new GraphicContext());
        AffineTransform transform = new AffineTransform();
        transform.translate(fx, fy);
        gen.getCurrentState().concatMatrix(transform);
        Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, imw, imh);
        painter.paint((Graphics2D)((Object)graphics), (Rectangle2D)area);
        gen.restoreGraphicsState();
        gen.commentln("%FOPEndGraphics2D");
    }
}

