/*
 * Decompiled with CFR 0.152.
 */
package com.piro.bezier;

import com.piro.bezier.Bezier;
import com.piro.bezier.BezierHistory;
import com.piro.bezier.ParseException;
import com.piro.bezier.PathHandler;
import java.util.ArrayList;

public class BezierListProducer
implements PathHandler {
    final ArrayList<Bezier> bezierSegs = new ArrayList();
    float[] coords = new float[6];
    float curveLength = 0.0f;
    BezierHistory hist = new BezierHistory();

    @Override
    public void startPath() throws ParseException {
        this.curveLength = 0.0f;
        this.bezierSegs.clear();
    }

    @Override
    public void movetoRel(float x, float y) throws ParseException {
        float offx = this.hist.lastPoint.x;
        float offy = this.hist.lastPoint.y;
        this.movetoAbs(offx + x, offy + y);
    }

    @Override
    public void movetoAbs(float x, float y) throws ParseException {
        this.hist.setLastPoint(x, y);
    }

    @Override
    public void closePath() throws ParseException {
    }

    @Override
    public void linetoRel(float x, float y) throws ParseException {
        float offx = this.hist.lastPoint.x;
        float offy = this.hist.lastPoint.y;
        this.linetoAbs(offx + x, offy + y);
    }

    @Override
    public void linetoAbs(float x, float y) throws ParseException {
        this.coords[0] = x;
        this.coords[1] = y;
        Bezier b = new Bezier(this.hist.lastPoint.x, this.hist.lastPoint.y, this.coords, 1);
        this.bezierSegs.add(b);
        this.curveLength += b.getLength();
        this.hist.setLastPoint(x, y);
        this.hist.setLastKnot(x, y);
    }

    @Override
    public void linetoHorizontalRel(float x) throws ParseException {
        this.linetoAbs(x + this.hist.lastPoint.x, this.hist.lastPoint.y);
    }

    @Override
    public void linetoHorizontalAbs(float x) throws ParseException {
        this.linetoAbs(x, this.hist.lastPoint.y);
    }

    @Override
    public void linetoVerticalRel(float y) throws ParseException {
        this.linetoAbs(this.hist.lastPoint.x, y + this.hist.lastPoint.y);
    }

    @Override
    public void linetoVerticalAbs(float y) throws ParseException {
        this.linetoAbs(this.hist.lastPoint.x, y);
    }

    @Override
    public void curvetoCubicRel(float x1, float y1, float x2, float y2, float x, float y) throws ParseException {
        float offx = this.hist.lastPoint.x;
        float offy = this.hist.lastPoint.y;
        this.curvetoCubicAbs(x1 + offx, y1 + offy, x2 + offx, y2 + offy, x + offx, y + offy);
    }

    @Override
    public void curvetoCubicAbs(float x1, float y1, float x2, float y2, float x, float y) throws ParseException {
        this.coords[0] = x1;
        this.coords[1] = y1;
        this.coords[2] = x2;
        this.coords[3] = y2;
        this.coords[4] = x;
        this.coords[5] = y;
        Bezier b = new Bezier(this.hist.lastPoint.x, this.hist.lastPoint.y, this.coords, 3);
        this.bezierSegs.add(b);
        this.curveLength += b.getLength();
        this.hist.setLastPoint(x, y);
        this.hist.setLastKnot(x2, y2);
    }

    @Override
    public void curvetoCubicSmoothRel(float x2, float y2, float x, float y) throws ParseException {
        float offx = this.hist.lastPoint.x;
        float offy = this.hist.lastPoint.y;
        this.curvetoCubicSmoothAbs(x2 + offx, y2 + offy, x + offx, y + offy);
    }

    @Override
    public void curvetoCubicSmoothAbs(float x2, float y2, float x, float y) throws ParseException {
        float oldKx = this.hist.lastKnot.x;
        float oldKy = this.hist.lastKnot.y;
        float oldX = this.hist.lastPoint.x;
        float oldY = this.hist.lastPoint.y;
        float k1x = oldX * 2.0f - oldKx;
        float k1y = oldY * 2.0f - oldKy;
        this.coords[0] = k1x;
        this.coords[1] = k1y;
        this.coords[2] = x2;
        this.coords[3] = y2;
        this.coords[4] = x;
        this.coords[5] = y;
        Bezier b = new Bezier(this.hist.lastPoint.x, this.hist.lastPoint.y, this.coords, 3);
        this.bezierSegs.add(b);
        this.curveLength += b.getLength();
        this.hist.setLastPoint(x, y);
        this.hist.setLastKnot(x2, y2);
    }

    @Override
    public void curvetoQuadraticRel(float x1, float y1, float x, float y) throws ParseException {
        float offx = this.hist.lastPoint.x;
        float offy = this.hist.lastPoint.y;
        this.curvetoQuadraticAbs(x1 + offx, y1 + offy, x + offx, y + offy);
    }

    @Override
    public void curvetoQuadraticAbs(float x1, float y1, float x, float y) throws ParseException {
        this.coords[0] = x1;
        this.coords[1] = y1;
        this.coords[2] = x;
        this.coords[3] = y;
        Bezier b = new Bezier(this.hist.lastPoint.x, this.hist.lastPoint.y, this.coords, 2);
        this.bezierSegs.add(b);
        this.curveLength += b.getLength();
        this.hist.setLastPoint(x, y);
        this.hist.setLastKnot(x1, y1);
    }

    @Override
    public void curvetoQuadraticSmoothRel(float x, float y) {
        float offx = this.hist.lastPoint.x;
        float offy = this.hist.lastPoint.y;
        this.curvetoQuadraticSmoothAbs(x + offx, y + offy);
    }

    @Override
    public void curvetoQuadraticSmoothAbs(float x, float y) throws ParseException {
        this.curvetoQuadraticAbs(this.hist.lastKnot.x, this.hist.lastKnot.y, x, y);
    }

    @Override
    public void arcRel(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) throws ParseException {
    }

    @Override
    public void arcAbs(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) throws ParseException {
    }

    @Override
    public void endPath() throws ParseException {
        this.hist.setLastPoint(this.hist.startPoint.x, this.hist.startPoint.y);
        this.hist.setLastKnot(this.hist.startPoint.x, this.hist.startPoint.y);
    }
}

