/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.io;

import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.IOListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class Utilities {
    public static int BUFFER_SIZE = 8192;
    private ArrayList listeners = new ArrayList();
    private boolean interrupt = false;

    public static void deleteFile(String dir) {
        File d = new File(dir);
        if (d.exists()) {
            if (d.isDirectory()) {
                File[] files = d.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (files[i].isFile()) {
                        files[i].delete();
                        files[i] = null;
                    } else {
                        Utilities.deleteFile(files[i].getAbsolutePath());
                    }
                    ++i;
                }
                d.delete();
            } else {
                d.delete();
                d = null;
            }
        }
    }

    public static int fileCount(String path) {
        int count = 0;
        File directory = new File(path);
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    ++count;
                } else if (files[i].isDirectory()) {
                    count += Utilities.fileCount(files[i].getPath());
                }
                ++i;
            }
        }
        return count;
    }

    private void processCopy(File from, File to) {
        File dest = null;
        if (to.exists() && to.isDirectory()) {
            dest = new File(String.valueOf(to.getAbsolutePath()) + File.separator + from.getName());
            int count = 1;
            while (dest.exists()) {
                dest = new File(String.valueOf(to.getAbsolutePath()) + File.separator + from.getName() + "(" + count + ")");
                ++count;
            }
        } else {
            dest = to;
        }
        if (from.isFile()) {
            this.store(from, dest);
        } else if (from.isDirectory()) {
            dest.mkdir();
            File[] files = from.listFiles();
            int i = 0;
            while (i < files.length && !this.interrupt) {
                this.processCopy(files[i], dest);
                ++i;
            }
        }
    }

    private void store(File from, File to) {
        this.fireStartWriting(from.getName(), from.length());
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(from));
                out = new BufferedOutputStream(new FileOutputStream(to));
                byte[] bytes = new byte[1024];
                int len = -1;
                while ((len = in.read(bytes)) > -1 && !this.interrupt) {
                    ((BufferedOutputStream)out).write(bytes, 0, len);
                }
                in.close();
                out.close();
                in = null;
                out = null;
                this.fireCompleteWriting();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void copy(File from, File to) {
        this.interrupt = false;
        if (from.isFile()) {
            this.fireCopy(1);
        } else {
            this.fireCopy(Utilities.fileCount(from.getAbsolutePath()));
        }
        this.processCopy(from, to);
        this.fireComplete();
    }

    public void addIOListener(IOListener l) {
        this.listeners.add(l);
    }

    public void removeIOListener(IOListener l) {
        this.listeners.remove(l);
    }

    private void fireStartWriting(String name, long length) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IOListener l = (IOListener)i.next();
            l.startWriting(name, length);
        }
    }

    private void fireCopy(int count) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IOListener l = (IOListener)i.next();
            l.copy(count);
        }
    }

    private void fireStore(long currentBytes, long total) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IOListener l = (IOListener)i.next();
            l.wrote(currentBytes, total);
        }
    }

    private void fireCompleteWriting() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IOListener l = (IOListener)i.next();
            l.completeWriting();
        }
    }

    private void fireComplete() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            IOListener l = (IOListener)i.next();
            l.complete();
        }
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public void copy(File from, FileModel to) throws Exception {
        this.interrupt = false;
        if (from.isFile()) {
            this.fireCopy(1);
        } else {
            this.fireCopy(Utilities.fileCount(from.getAbsolutePath()));
        }
        this.processCopy(from, to);
        this.fireComplete();
    }

    public void copy(FileModel from, FileModel to) throws Exception {
        this.interrupt = false;
        if (from.isFile()) {
            this.fireCopy(1);
        }
        this.processCopy(from, to);
        this.fireComplete();
    }

    private void processCopy(File from, FileModel to) throws Exception {
        FileModel dest = to;
        if (to.exists() && !to.isFile() && from.isFile()) {
            dest = to.createFile(from.getName());
            int count = 1;
            while (dest.exists() && count < 31) {
                dest = to.createFile(String.valueOf(from.getName()) + "(" + count + ")");
                ++count;
            }
        }
        if (from.isFile()) {
            this.fireStartWriting(from.getName(), from.length());
            this.copy(new FileInputStream(from), dest.getContent().getOutputStream());
        } else if (from.isDirectory()) {
            dest = dest.createDirectory(from.getName());
            File[] files = from.listFiles();
            int i = 0;
            while (i < files.length && !this.interrupt) {
                this.processCopy(files[i], dest);
                ++i;
            }
        }
    }

    private void processCopy(FileModel from, FileModel to) throws Exception {
        FileModel dest = to;
        if (to.exists() && !to.isFile() && from.isFile()) {
            dest = to.createFile(from.getName());
            int count = 1;
            while (dest.exists() && count < 31) {
                dest = to.createFile(String.valueOf(from.getName()) + "(" + count + ")");
                ++count;
            }
        }
        if (from.isFile()) {
            this.fireStartWriting(from.getName(), from.getLength());
            this.copy(from.getContent().getInputStream(), dest.getContent().getOutputStream());
        } else if (!from.isFile()) {
            dest = dest.createDirectory(from.getName());
            FileModel[] files = from.getChildren();
            int i = 0;
            while (i < files.length && !this.interrupt) {
                this.processCopy(files[i], dest);
                ++i;
            }
        }
    }

    private void copy(InputStream in, OutputStream out) throws Exception {
        BufferedInputStream inBuffer = null;
        FilterOutputStream outBuffer = null;
        try {
            inBuffer = new BufferedInputStream(in);
            outBuffer = new BufferedOutputStream(out);
            byte[] bytes = new byte[BUFFER_SIZE];
            int len = -1;
            while ((len = inBuffer.read(bytes)) > -1 && !this.interrupt) {
                ((BufferedOutputStream)outBuffer).write(bytes, 0, len);
            }
            inBuffer.close();
            ((BufferedOutputStream)outBuffer).flush();
            outBuffer.close();
            inBuffer = null;
            outBuffer = null;
            this.fireCompleteWriting();
        }
        finally {
            if (inBuffer != null) {
                try {
                    inBuffer.close();
                    inBuffer = null;
                }
                catch (Exception exception) {}
            }
            if (outBuffer != null) {
                try {
                    outBuffer.close();
                    outBuffer = null;
                }
                catch (Exception exception) {}
            }
        }
    }
}

