/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui;

import de.miethxml.toolkit.auth.AuthenticationReceiver;
import de.miethxml.toolkit.auth.ui.LoginUI;
import de.miethxml.toolkit.io.DefaultFileModelHandler;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.io.FileModelManager;
import de.miethxml.toolkit.io.VFSFileModelHandler;
import de.miethxml.toolkit.io.filter.ExtensionFileModelFilter;
import de.miethxml.toolkit.repository.RepositoryModelImpl;
import de.miethxml.toolkit.repository.ui.RepositoryModelViewBuilder;
import de.miethxml.toolkit.ui.PanelFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;

public class SimpleUI {
    private JFrame frame;
    private JTextField left;
    private JTextField right;
    RepositoryModelImpl leftModel;
    RepositoryModelImpl rightModel;
    private CardLayout card;
    FileModelManager manager;

    public void init() {
        this.frame = new JFrame("FileManager");
        this.card = new CardLayout();
        this.frame.getContentPane().setLayout(this.card);
        LoginUI login = new LoginUI(new AuthenticationReceiver(){

            public boolean accept(String name, char[] pass) {
                try {
                    SimpleUI.this.leftModel.setBase("sftp://" + name + ":" + new String(pass) + "@192.168.100.3");
                    SimpleUI.this.card.show(SimpleUI.this.frame.getContentPane(), "1");
                    return true;
                }
                catch (FileModelException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        });
        this.frame.getContentPane().add((Component)login.getView(), "2");
        this.manager = new FileModelManager();
        this.manager.addFileModelHandler(new VFSFileModelHandler());
        this.manager.addFileModelHandler(new DefaultFileModelHandler());
        this.leftModel = new RepositoryModelImpl(this.manager);
        this.leftModel.addFileModelFilter(new ExtensionFileModelFilter(".xml"));
        RepositoryModelViewBuilder builder = new RepositoryModelViewBuilder(this.leftModel, new JPopupMenu(), null);
        JTree tree = builder.getRepositoryTree(true);
        JSplitPane sp = PanelFactory.createDefaultSplitPane();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(tree), "Center");
        this.left = new JTextField(30);
        this.left.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    SimpleUI.this.leftModel.setBase(SimpleUI.this.left.getText());
                }
                catch (FileModelException e) {
                    e.printStackTrace();
                }
            }
        });
        panel.add((Component)this.left, "North");
        sp.setLeftComponent(panel);
        this.rightModel = new RepositoryModelImpl(this.manager);
        builder = new RepositoryModelViewBuilder(this.rightModel, new JPopupMenu(), null);
        tree = builder.getRepositoryTree(true);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(tree), "Center");
        this.right = new JTextField(30);
        this.right.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    SimpleUI.this.rightModel.setBase(SimpleUI.this.right.getText());
                }
                catch (FileModelException e) {
                    e.printStackTrace();
                }
            }
        });
        panel.add((Component)this.right, "North");
        sp.setRightComponent(panel);
        this.frame.getContentPane().add((Component)sp, "1");
        this.frame.setSize(800, 600);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        SimpleUI ui = new SimpleUI();
        ui.init();
    }
}

