/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Edge;
import eu.mihosoft.vrl.v3d.ISlice;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.DelaunayTriangle;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.Poly2Tri;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.Polygon;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;

public class Slice {
    private static ISlice sliceEngine = (incoming, slicePlane, normalInsetDistance) -> {
        double COINCIDENCE_TOLERANCE = 1.0E-4;
        ArrayList rawPolygons = new ArrayList();
        Matrix4d inverse = slicePlane.scale(1.0 / slicePlane.getScale()).getInternalMatrix();
        inverse.invert();
        CSG planeCSG = new Cube(incoming.getMaxX() - incoming.getMinX(), incoming.getMaxY() - incoming.getMinY(), 1.0).noCenter().toCSG();
        planeCSG = planeCSG.movex((planeCSG.getMaxX() - planeCSG.getMinX()) / -2.0).movey((planeCSG.getMaxY() - planeCSG.getMinY()) / -2.0);
        incoming.getPolygons();
        rawPolygons.addAll(incoming.intersect(planeCSG).getPolygons().stream().filter(Slice::isPolygonAtZero).collect(Collectors.toList()));
        ArrayList<eu.mihosoft.vrl.v3d.Polygon> triangles = new ArrayList<eu.mihosoft.vrl.v3d.Polygon>();
        for (int i = 0; i < rawPolygons.size(); ++i) {
            Polygon p = PolygonUtil.fromCSGPolygon((eu.mihosoft.vrl.v3d.Polygon)rawPolygons.get(i));
            Poly2Tri.triangulate(p);
            List<DelaunayTriangle> list = p.getTriangles();
            for (int j = 0; j < list.size(); ++j) {
                triangles.add(list.get(j).toPolygon());
            }
        }
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (eu.mihosoft.vrl.v3d.Polygon polygon : triangles) {
            if (polygon.vertices.size() != 3) {
                throw new RuntimeException("Triangulation failed and an invalid poly is created!");
            }
            edges.add(new Edge(polygon.vertices.get(0), polygon.vertices.get(1)));
            edges.add(new Edge(polygon.vertices.get(1), polygon.vertices.get(2)));
            edges.add(new Edge(polygon.vertices.get(2), polygon.vertices.get(0)));
        }
        return triangles;
    };

    private static boolean isPolygonAtZero(eu.mihosoft.vrl.v3d.Polygon polygon) {
        for (Vertex v : polygon.vertices) {
            if (Slice.isVertexAtZero(v)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVertexAtZero(Vertex vertex) {
        double SLICE_UPPER_BOUND = 0.001;
        double SLICE_LOWER_BOUND = -0.001;
        return vertex.getZ() < 0.001 && vertex.getZ() > -0.001;
    }

    public static List<eu.mihosoft.vrl.v3d.Polygon> slice(CSG incoming, Transform slicePlane, double normalInsetDistance) {
        return Slice.getSliceEngine().slice(incoming, slicePlane, normalInsetDistance);
    }

    public static ISlice getSliceEngine() {
        return sliceEngine;
    }

    public static void setSliceEngine(ISlice sliceEngine) {
        Slice.sliceEngine = sliceEngine;
    }
}

