/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.org.poly2tri;

import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TriangulationPoint;

class TriangulationUtil {
    public static final double EPSILON = 1.0E-12;

    TriangulationUtil() {
    }

    public static boolean smartIncircle(TriangulationPoint pa, TriangulationPoint pb, TriangulationPoint pc, TriangulationPoint pd) {
        double cdy;
        double adxcdy;
        double bdxady;
        double pdx = pd.getX();
        double pdy = pd.getY();
        double adx = pa.getX() - pdx;
        double ady = pa.getY() - pdy;
        double bdx = pb.getX() - pdx;
        double bdy = pb.getY() - pdy;
        double adxbdy = adx * bdy;
        double oabd = adxbdy - (bdxady = bdx * ady);
        if (oabd <= 0.0) {
            return false;
        }
        double cdx = pc.getX() - pdx;
        double cdxady = cdx * ady;
        double ocad = cdxady - (adxcdy = adx * (cdy = pc.getY() - pdy));
        if (ocad <= 0.0) {
            return false;
        }
        double alift = adx * adx + ady * ady;
        double bdxcdy = bdx * cdy;
        double cdxbdy = cdx * bdy;
        double blift = bdx * bdx + bdy * bdy;
        double clift = cdx * cdx + cdy * cdy;
        double det = alift * (bdxcdy - cdxbdy) + blift * ocad + clift * oabd;
        return det > 0.0;
    }

    public static boolean inScanArea(TriangulationPoint pa, TriangulationPoint pb, TriangulationPoint pc, TriangulationPoint pd) {
        double cdy;
        double adxcdy;
        double bdxady;
        double pdx = pd.getX();
        double pdy = pd.getY();
        double adx = pa.getX() - pdx;
        double ady = pa.getY() - pdy;
        double bdx = pb.getX() - pdx;
        double bdy = pb.getY() - pdy;
        double adxbdy = adx * bdy;
        double oabd = adxbdy - (bdxady = bdx * ady);
        if (oabd <= 0.0) {
            return false;
        }
        double cdx = pc.getX() - pdx;
        double cdxady = cdx * ady;
        double ocad = cdxady - (adxcdy = adx * (cdy = pc.getY() - pdy));
        return !(ocad <= 0.0);
    }

    public static Orientation orient2d(TriangulationPoint pa, TriangulationPoint pb, TriangulationPoint pc) {
        double detright;
        double detleft = (pa.getX() - pc.getX()) * (pb.getY() - pc.getY());
        double val = detleft - (detright = (pa.getY() - pc.getY()) * (pb.getX() - pc.getX()));
        if (val > -1.0E-12 && val < 1.0E-12) {
            return Orientation.Collinear;
        }
        if (val > 0.0) {
            return Orientation.CCW;
        }
        return Orientation.CW;
    }

    public static enum Orientation {
        CW,
        CCW,
        Collinear;

    }
}

