/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.IOException;
import java.nio.file.Paths;

public class BreadBoardConnector {
    private double boardMountingThickness = 2.0;
    private double breadBoardThickness = 9.0;
    private double connectorDepth = 30.0;
    private double pegHeight = 1.0;
    private double pegToothHeight = 0.3;
    private double pegOverlap = 0.6;
    private double boardMountingWidth = 8.1;
    private double breadBoardToPiMountDistance = 26.0;

    public CSG toCSG() {
        double th = 2.0;
        double smh = this.boardMountingWidth;
        double bmth = this.boardMountingThickness;
        double bbpbd = this.breadBoardToPiMountDistance;
        double bbth = this.breadBoardThickness - th;
        double pth = this.pegToothHeight;
        double ph = this.pegHeight;
        double po = this.pegOverlap;
        return Extrude.points(new Vector3d(0.0, 0.0, this.connectorDepth), new Vector3d(-th, -th), new Vector3d(smh + pth + ph, -th), new Vector3d(smh + pth + Math.max(ph / 3.0, 0.4), 0.0 + po), new Vector3d(smh + pth, 0.0 + po), new Vector3d(smh, 0.0), new Vector3d(0.0, 0.0), new Vector3d(0.0, bmth), new Vector3d(smh, bmth), new Vector3d(smh, bmth + th), new Vector3d(0.0, bmth + th), new Vector3d(0.0, bmth + bbpbd - th), new Vector3d(smh, bmth + bbpbd - th), new Vector3d(smh, bmth + th + bbpbd - th), new Vector3d(0.0, bmth + th + bbpbd - th), new Vector3d(0.0, bmth + th + bbpbd + bbth), new Vector3d(smh, bmth + th + bbpbd + bbth), new Vector3d(smh, bmth + th + bbpbd + bbth + th), new Vector3d(0.0, bmth + th + bbpbd + bbth + th), new Vector3d(-th, bmth + th + bbpbd + bbth + th));
    }

    public static void main(String[] args) throws IOException {
        BreadBoardConnector arConnect = new BreadBoardConnector();
        FileUtil.write(Paths.get("bread-board-connector-tmp.stl", new String[0]), arConnect.toCSG().transformed(Transform.unity().mirror(Plane.XY_PLANE).rotY(180.0)).toStlString());
    }
}

