/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;

public class MoebiusStairs {
    private double n = 45.0;
    private double twists = 1.0;
    private double tilt = 0.0;

    public MoebiusStairs resolution(double n) {
        this.n = n;
        return this;
    }

    public MoebiusStairs twists(double twists) {
        this.twists = twists;
        return this;
    }

    public CSG toCSG() {
        CSG result = null;
        CSG firstCube = null;
        CSG prevCube = null;
        int i = 1;
        while ((double)i <= this.n * 2.0) {
            CSG union;
            double deg = (double)i * 360.0 / this.n;
            Transform rot1 = Transform.unity().rotZ(deg);
            Transform translate1 = Transform.unity().translate(-20.0 + 5.0 * MoebiusStairs.sin((double)i * 360.0 * (this.twists + 0.5) / this.n), 0.0, 8.0 * MoebiusStairs.cos((double)(i * 360) * (this.twists + 0.5) / this.n));
            Transform rot2 = Transform.unity().rotX(90.0 - this.tilt);
            Transform finalTransform = rot1.apply(translate1).apply(rot2);
            CSG cube = new Cube(3.0 + this.abs(8.0 * MoebiusStairs.cos(30.0 + (this.twists + 0.5) * deg)), 4.0, 4.0).toCSG();
            cube = cube.transformed(finalTransform);
            if (i == 1) {
                firstCube = cube;
            }
            if (result == null) {
                result = cube;
            }
            if (prevCube != null) {
                union = cube.hull(prevCube);
                result = result.union(union);
            }
            if ((double)i == this.n * 2.0) {
                union = firstCube.hull(prevCube);
                result = result.union(union);
            }
            prevCube = cube;
            ++i;
        }
        return result.transformed(Transform.unity().translateZ(10.0));
    }

    private static double sin(double deg) {
        return Math.sin(Math.toRadians(deg));
    }

    private static double cos(double deg) {
        return Math.cos(Math.toRadians(deg));
    }

    private double abs(double value) {
        return Math.abs(value);
    }

    public static void main(String[] args) throws IOException {
        MoebiusStairs moebiusStairs = new MoebiusStairs();
        CSG csg = moebiusStairs.toCSG();
        FileUtil.write(Paths.get("moebius-stairs.stl", new String[0]), csg.toStlString());
        csg.toObj().toFiles(Paths.get("moebius-stairs.obj", new String[0]));
    }
}

