/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Text3d;
import java.io.IOException;
import java.nio.file.Paths;

public class Text3dSample {
    public CSG toCSG(String text) {
        double border = 5.0;
        CSG text3d = new Text3d(text, "Arial", 12.0, 1.0).toCSG();
        double boxWidth = text3d.getBounds().getBounds().x + border * 2.0;
        double boxHeight = text3d.getBounds().getBounds().y + border * 2.0;
        double boxDepth = text3d.getBounds().getBounds().z;
        CSG box = new Cube(boxWidth, boxHeight, boxDepth).toCSG();
        return box.difference(text3d);
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("text3d-sample.stl", new String[0]), new Text3dSample().toCSG("JCSG - Text3d").toStlString());
    }
}

